/*** This Programs/Libraries are (C)opyright by S. Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights. If not,
 *** you can get it at http://www.cs.uni-potsdam.de/homepages/students/linuxer
 *** the logit-package. You will also find some other nice utillities there.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I'M NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/ 
#include <stdio.h>
#include "config.h"
#include <iostream.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include "usi++/usi++.h"

//int gethostname(char*, size_t);

#define MAXHOSTLEN 1000

// expect the 'destination' and the proto, IPPROTO_ICMP for example        
IP::IP(const char *dst, u_int8_t proto)
{
   	char *hname = new char[MAXHOSTLEN];
	int one = 1;
	
	memset(hname, 0, MAXHOSTLEN);
	memset(&iph, 0, sizeof(iph));
        memset(&ether, 0, sizeof(ether));
        memset(filter_string, 0, 1000);
	memset(options, 0, sizeof(options));
        
	gethostname(hname, MAXHOSTLEN-1);
	
   	rawfd = 0;
        
        iph.ttl = 64;
        iph.version = 4;
        iph.ihl = 5;
        iph.id = 0;
        iph.protocol = proto;
        set_src(hname);
	set_dst(dst);  
   	

	// open a socket
	if ((rawfd = socket(AF_INET, SOCK_RAW, proto)) < 0) {
           	perror("socket");
		exit(errno);
        }
	
	// let us write IP-headers
	if (setsockopt(rawfd, IPPROTO_IP, IP_HDRINCL, &one, sizeof(one)) < 0) {
		perror("setsockopt");
		exit(errno);
	}

	// specify destination
	saddr.sin_port = htons(0);
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = get_dst();
	
	
        // what in sendpack must be set is:
        // tot_len, check, frag_off
}

IP::IP(u_int32_t dst, u_int8_t proto)
{
	char *hname = new char[1000];
	int one = 1;

	memset(hname, 0, 1000);
   	memset(&iph, 0, sizeof(iph));
        memset(&ether, 0, sizeof(ether));
	memset(filter_string, 0, 1000);
	memset(options, 0, sizeof(options));
	
	gethostname(hname, 1000-1);
   	rawfd = 0;
        
        iph.ttl = 64;
        iph.version = 4;
        iph.ihl = 5;
        iph.id = 0;
        iph.protocol = proto;
        set_src(hname);
        set_dst(dst);    
                
	if ((rawfd = socket(AF_INET, SOCK_RAW, get_proto())) < 0) {
           	perror("socket");
		exit(errno);
        }
	if (setsockopt(rawfd, IPPROTO_IP, IP_HDRINCL, &one, sizeof(one)) < 0) {
		perror("setsockopt");
		exit(errno);
	}
        
	saddr.sin_port = htons(0);
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = get_dst();
    
}


IP::~IP()
{
   	if (rawfd)
           	close(rawfd);
}

u_int8_t IP::get_hlen()
{
   	return iph.ihl<<2;
}

int IP::set_hlen(u_int8_t l)
{
   	// not a alignment of 4?
   	if (l % 4)
           	return -1;
        iph.ihl = (2>>l);
	return 0;
}

u_int8_t IP::get_vers()
{
   	return iph.version;
}

int IP::set_vers(u_int8_t v)
{
   	iph.version = v;
        return 0;
}
 
u_int8_t IP::get_tos()
{
   	return iph.tos;
}

int IP::set_tos(u_int8_t tos)
{
   	iph.tos = tos;
        return 0;
}

u_int16_t IP::get_totlen()
{
#ifdef USI_LINUX
   	return ntohs(iph.tot_len);
#else
	return iph.tot_len;
#endif
}

int IP::set_totlen(u_int16_t t)
{
#ifdef USI_LINUX   
	iph.tot_len = htons(t);
#else
	iph.tot_len = t;
#endif
   	return 0;
}

u_int16_t IP::get_id()
{
   	return ntohs(iph.id);
}

int IP::set_id(u_int16_t id)
{
   	iph.id = htons(id);
        return 0;
}

u_int16_t IP::get_fragoff()
{
   	return ntohs(iph.frag_off);
}

int IP::set_fragoff(u_int16_t f)
{
   	iph.frag_off = htons(f);
        return  0;
}

u_int8_t IP::get_ttl()
{
   	return iph.ttl;
}

int IP::set_ttl(u_int8_t ttl)
{
   	iph.ttl = ttl;
        return 0;
}

u_int8_t IP::get_proto()
{
   	return iph.protocol;
}

int IP::set_proto(u_int8_t p)
{
        iph.protocol = p;
        return 0;
}

u_int16_t IP::get_sum()
{
   	return iph.check;
}

int IP::set_sum(u_int16_t s)
{
   	iph.check = s;
        return 0;
}

u_int32_t IP::get_dst()
{
	return iph.daddr;
}


char *IP::get_dst(int resolv)
{
   	 struct in_addr in;
   	 char *s = new char[MAXHOSTLEN];
         struct hostent *he;         
         
         memset(s, 0, MAXHOSTLEN);
         in.s_addr = iph.daddr;
         if (!resolv || (he = gethostbyaddr((char*)&in, sizeof(in), AF_INET)) == NULL)
            	strncpy(s, inet_ntoa(in), MAXHOSTLEN-1);
         else
            	strncpy(s, he->h_name, MAXHOSTLEN-1);
         return s;
}



u_int32_t IP::get_src()
{
   	return iph.saddr;
}

char *IP::get_src(int resolv)
{
   	 struct in_addr in;
   	 char *s = new char[MAXHOSTLEN];
         struct hostent *he;         
         
         memset(s, 0, MAXHOSTLEN);
         in.s_addr = iph.saddr;
         if (!resolv || (he = gethostbyaddr((char*)&in, sizeof(in), AF_INET)) == NULL)
            	strncpy(s, inet_ntoa(in), MAXHOSTLEN);
         else
            	strncpy(s, he->h_name, MAXHOSTLEN);
         return s;
}

int IP::set_src(u_int32_t s)
{
   	iph.saddr = s;
        return 0;
}

int IP::set_src(const char* host)
{
   	struct hostent *he;
        
        if ((he = gethostbyname(host)) == NULL) {
           	perror("gethostbyname");
                exit(errno);
        }
        memcpy(&iph.saddr, he->h_addr, he->h_length);
        return 0;
}

// set new destination adress
int IP::set_dst(u_int32_t d)
{
	iph.daddr = d;
        saddr.sin_addr.s_addr = d;
	return 0;
}

int IP::set_dst(const char* host)
{
   	struct hostent *he;
        
        if ((he = gethostbyname(host)) == NULL) {
           	perror("gethostbyname");
                exit(errno);
        }
        memcpy(&iph.daddr, he->h_addr, he->h_length);
        memcpy(&saddr.sin_addr, he->h_addr, he->h_length);
        return 0;
}


int IP::sendpack(void *payload, int paylen)
{	
	// get mem for packet	
	char *s = new char[paylen+sizeof(iph)];
	memset(s, 0, paylen+sizeof(iph));
	
	set_totlen(paylen + sizeof(iph));		// how long ?
	set_fragoff(0);		
	iph.check = 0;

	//iph.check = in_cksum((unsigned short*)&iph, sizeof(iph));
	memcpy(s, &iph, sizeof(iph));
	memcpy(s + sizeof(iph), payload, paylen);
	
	if (sendto(rawfd, s, paylen+sizeof(iph), 0, (struct sockaddr*)&saddr,
	           sizeof(saddr)) < 0) {
		   perror("sendto");
		   exit(errno);
	}
	return 0;
}


int IP::sendpack(char *payload)
{
	return sendpack((void*)payload, strlen(payload));
}


int IP::recvpack(void *buf, int len)
{
	struct sockaddr_in saddr;
#ifdef USI_LINUX 
	unsigned int slen = sizeof(saddr);
#else
	int slen = sizeof(saddr);
#endif
	char *tmp = new char[len + 40];
	int iplen = 0;
	
	memset(tmp, 0, len);

	// get the packet
	if (recvfrom(rawfd, tmp, len, 0, (struct sockaddr*)&saddr, &slen) < 0) {
		perror("recvfrom");
		exit(errno);
	}
	iplen = iph.ihl << 2;
	if (iplen > 60)
		iplen = 60;
	
	memcpy(&iph, tmp, sizeof(iph));

	if (buf)
		memcpy(buf, tmp + iplen, len);
	
	delete[] tmp;
	return 0;
}

// sniff for packets
int IP::sniffpack(void *buf, int len)
{
	char *tmp;
	int iplen = 0, framelen = 0;
	struct usipp::iphdr *i;
		
	while ((tmp = (char*)pcap_next(pd, &phdr)) == NULL);
	
        switch (datalink) {
        case DLT_EN10MB:
		framelen = sizeof(ether);
           	i = (struct usipp::iphdr*)(tmp + framelen);
                break;
        case DLT_PPP:
		framelen = PPP_LEN;
           	i = (struct usipp::iphdr*)(tmp + PPP_LEN);
                break;
        case DLT_SLIP:
		framelen = SLIP_LEN;
           	i = (struct usipp::iphdr*)(tmp + SLIP_LEN);
                break;
        default:
           	return -1;
        }
        iplen = i->ihl<<2;
#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif
	if (iplen > 60)
		iplen = 60;

	memcpy(&iph, i, iplen);	

	int r = phdr.len-iplen-framelen;
        if (buf)
		memcpy(buf, (char*)i + iplen, min(len, r));
	return r;
}

// initialize device for packet-capturing
int IP::init_device(char *dev, int promisc, int snaplen)
{
   	
        if ((pd = pcap_open_live(dev, snaplen, promisc, 500, errbuff)) == NULL) {
           	fprintf(stderr, "%s", errbuff);
                exit(errno);
        }
        
        if (pcap_lookupnet(dev, &localnet, &netmask, errbuff) < 0) {
           	pcap_perror(pd, "pcap_lookupnet");
                exit(errno);
        }
        sprintf(filter_string, "ip");
        
        if (pcap_compile(pd, &filter, filter_string, 1, netmask) < 0) {
           	pcap_perror(pd, "pcap_compile");
                exit(errno);
        }
        if (pcap_setfilter(pd, &filter) < 0) {
           	pcap_perror(pd, "pcap_setfilter");
                exit(errno);
        }
        if ((datalink = pcap_datalink(pd)) < 0) {
           	pcap_perror(pd, "pcap_datalink");
                exit(errno);
        }
	initialized = true;
	
        return 0;
}

// set a new filter for capturing
int IP::setfilter(char *s)
{
	
	if (!initialized)
		return -1;

   	memset(filter_string, 0, 1000);
	snprintf(filter_string, 1000, "%s", s);
        
        if (pcap_compile(pd, &filter, filter_string, 1, netmask) < 0) {
           	pcap_perror(pd, "pcap_compile");
                exit(errno);
        }

        if (pcap_setfilter(pd, &filter) < 0) {
           	pcap_perror(pd, "pcap_setfilter");
                exit(errno);
        }
        return 0;
}

