;;; protocol-mode.el

;; Author: Laurent Riesterer


(defvar protocol-font-lock-keywords
  (eval-when-compile
    (list
     ;;
     ;; Protocol name declarations.
     '("\\<\\(protocol\\)\\>[ \t]*\\(\\([:&]\\|\\sw\\)+\\)"
       (1 font-lock-keyword-face) (2 font-lock-function-name-face nil t))

     ;;
     ;; Keywords.

     ;; options for field
     (cons (concat "[ \t]\\("
		   "size\\|type\\|map\\|help\\|nextlayer\\|spec\\|default\\|nbelements"
		   "\\|read-only\\)\\>")
	   'font-lock-type-face)

     ;; types
     (cons (concat "\\<\\("
		   "address_\\(ip\\|ethernet\\)\\|flags\\|integer\\|checksum\\|length"
		   "\\|list\\|s\\(ame\\|pare\\)list"
		   "\\|record\\|mapper\\|s\\(tring\\|witch\\)\\|none"
		   "\\)\\>")
	   'font-lock-reference-face)

     ;; Field declaration
     '("\\<\\(field\\(variable\\)?\\(array\\)?\\)\\>[ \t]*\\(\\([-:&]\\|\\sw\\)+\\)?"
       (1 font-lock-keyword-face) (4 font-lock-function-name-face t))

     ;; comment
     '("\\(#.*\\)" 0 font-lock-comment-face t)
     ;'("#[0-9A-Fa-f]+\\([ \t\n][^#$]+\\|$\\)" 0 font-lock-normal-face t)
     ;'("\"#.*\"" 0 font-lock-string-face t)

     ))
  "Default expressions to highlight in TCL modes.")


(defun protocol-mode ()
  "Major mode for editing protocol spefics."
  (interactive)
  (let ((switches nil)
	s)
    (kill-all-local-variables)
    (setq major-mode 'protocol-mode)
    (setq mode-name "Protocol")
    (set (make-local-variable 'comment-start) "#")
    (set (make-local-variable 'comment-start-skip) "# *")
    (set (make-local-variable 'font-lock-defaults)
	 '(protocol-font-lock-keywords nil nil ((?_ . "w") (?- . "-"))))
;    (modify-syntax-entry ?# "<")
;    (modify-syntax-entry ?- "-")
    (modify-syntax-entry ?+ "-")
    (modify-syntax-entry ?( "-")
    (modify-syntax-entry ?) "-")
    (modify-syntax-entry ?\n ">")
    (setq tab-width 4)
    (run-hooks 'protocol-mode-hook)))


(provide 'protocol-mode)
