#-------------------------------------------------------------------------------------------------
#	none
#-------------------------------------------------------------------------------------------------

protocol test_none = {
	spec = "none"
	size = 10

    field -none1 @ (0, 1) = {
        type = none
    }	
    field -none2 @ (1, 2) = {
        type = none
    }	
    field -none4 @ (3, 4) = {
        type = none
    }	
}

#-------------------------------------------------------------------------------------------------
#	address_ethernet + address_ip
#-------------------------------------------------------------------------------------------------

protocol test_addresses = {
	spec = "ethernet + ip"
	size = 10

    field -ethernet @ (0, 6) = {
        type = address_ethernet
    }	
	
    field -ip @ (6, 4) = {
        type = address_ip
    }
}

#-------------------------------------------------------------------------------------------------
#	integer
#-------------------------------------------------------------------------------------------------

protocol test_integer = {
	spec = "integer"
	size = 19

    field -int1 @ (0, 1) = {
        type = integer
    }	
    field -int2 @ (1, 2) = {
        type = integer
    }	
    field -int3 @ (3, 3) = {
        type = integer
    }	
    field -int4 @ (6, 4) = {
        type = integer
    }	

    field -nibble1 @ (10, 0.4) = {
        type = integer
    }	
    field -nibble2 @ (10.4, 0.4) = {
        type = integer
    }	

    field -bit1 @ (11, 0.3) = {
        type = integer
    }	
    field -bit2 @ (11.3, 0.13) = {
        type = integer
    }
	# bit field in middle of a word + word to control
	# 
	#     0000 0xxx xxxx xxx0
	#
    field -bit3 @ (13.5, 0.10) = {
        type = integer
    }
	field -control3 @ (13, 2) = {
		type = integer
	}
	# bit field in middle of a long + long to control
	# 
	#     0000 0000 0000 00xx xxxx xxxx xx00 0000
	#
    field -bit4 @ (15.14, 1.4) = {
        type = integer
    }
	field -control4 @ (15, 4) = {
		type = integer
	}
}

#-------------------------------------------------------------------------------------------------
#	list, sparelist & samelist
#-------------------------------------------------------------------------------------------------

protocol test_list = {
	spec = "list, sparelist & samelist"
	size = 0		# not meaningful for the validation

	# validate list on 1 byte as list use the same routine as 'integer' to get/set the
	# numerical value

    field -list @ (0, 1) = {
        type = list {
                   1 "item1" "verbose item 1"
                   2 "item2" "verbose item 2"
                   3 "item3" "verbose item 3"
                   4 "item4" "verbose item 4"
                   5 "item5" "verbose item 5"
			   }
    }	
    field -sparelist @ (1, 2) = {
        type = list {
                   100 "item100" "verbose item 100"
                   200 "item200" "verbose item 200"
                   300 "item300" "verbose item 300"
                   400 "item400" "verbose item 400"
                   500 "item500" "verbose item 500"
			   }
    }	

    field -samelist1 @ (3, 1) = {
        type = samelist(-list)
    }	
    field -samelist2 @ (4, 2) = {
        type = samelist(-sparelist)
    }	
}

#-------------------------------------------------------------------------------------------------
#	flags
#-------------------------------------------------------------------------------------------------

protocol test_flags = {
	spec = "flags"
	size = 0		# not meaningful for the validation

	# validate list on 1 byte as list use the same routine as 'integer' to get/set the
	# numerical value

    field -flags @ (0, 1) = {
        type = flags {
					0x80 "bit7"		"bit7 off" "bit7 on"
					0x40 "bit6"		"bit6 off" "bit6 on"
					0x20 "bit5"		"bit5 off" "bit5 on"
					0x10 "bit4"		"bit4 off" "bit4 on"
					0x08 "bit3"		"bit3 off" "bit3 on"
					0x04 "bit2"		"bit2 off" "bit2 on"
					0x02 "bit1"		"bit1 off" "bit1 on"
					0x01 "bit0"		"bit0 off" "bit0 on"
			   }
    }	
}
