#-------------------------------------------------------------------------------------------------
#   TCP - Transport Control Protocol
#-------------------------------------------------------------------------------------------------

protocol tcp = {
	spec = "RFC 793 + RFC 1700 (Assigned Numbers)"
    size = '4*%data(12, 0.4)'
	nextlayer = '%string(-src)', '%string(-dest)'

    field -src @ (0, 2) = {
        type = sparelist {
                   1 "tcpmux" "TCP Port Service Multiplexer"
                   2 "compressnet" "Management Utility"
                   3 "compressnet" "Compression Process"
                   5 "rje" "Remote Job Entry"
                   7 "echo" "Echo"
                   9 "discard" "Discard"
                   11 "systat" "Active Users"
                   13 "daytime" "Daytime"
                   15 "netstat" "Netstat"
                   17 "qotd" "Quote of the Day"
                   18 "msp" "Message Send Protocol"
                   19 "chargen" "Character Generator"
                   20 "ftp-data" "File Transfer Protocol [Default Data]"
                   21 "ftp" "File Transfer Protocol [Control]"
                   22 "ssh" "Secure Shell"
                   23 "telnet" "Telnet protocol"
                   24 "priv-mail" "Any private mail system"
                   25 "smtp" "Simple Mail Transfer Protocol"
                   27 "nsw-fe" "NSW User System FE"
                   29 "msg-icp" "MSG ICP"
                   31 "msg-auth" "MSG Authentication"
                   33 "dsp" "Display Support Protocol"
                   35 "priv-print" "Any private printer server"
                   37 "time" "Time"
                   38 "rap" "Route Access Protocol"
                   39 "rlp" "Resource Location Protocol"
                   41 "graphics" "Graphics"
                   42 "name" "Host Name Server"
                   43 "nicname" "Who Is"
                   44 "mpm-flags" "MPM FLAGS Protocol"
                   45 "mpm" "Message Processing Module [recv]"
                   46 "mpm-snd" "MPM [default send]"
                   47 "ni-ftp" "NI FTP"
                   48 "auditd" "Digital Audit Daemon"
                   49 "bbn-login" "Login Host Protocol (TACACS)"
                   50 "re-mail-ck" "Remote Mail Checking Protocol"
                   51 "la-maint" "IMP Logical Address Maintenance"
                   52 "xns-time" "XNS Time Protocol"
                   53 "domain" "Domain Name Server"
                   54 "xns-ch" "XNS Clearinghouse"
                   55 "isi-gl" "ISI Graphics Language"
                   56 "xns-auth" "XNS Authentication"
                   57 "priv-term" "Any private terminal access"
                   58 "xns-mail" "XNS Mail"
                   59 "priv-file" "Any private file service"
                   61 "ni-mail" "NI MAIL"
                   62 "acas" "ACA Services"
                   63 "whois++" "Whois++"
                   64 "covia" "Communications Integrator (CI)"
                   65 "tacacs-ds" "TACACS-Database Service"
                   66 "sql*net" "Oracle SQL*NET"
                   67 "bootps" "Bootstrap Protocol Server"
                   68 "bootpc" "Bootstrap Protocol Client"
                   69 "tftp" "Trivial File Transfer"
                   70 "gopher" "Gopher"
                   71 "netrjs-1" "Remote Job Service"
                   72 "netrjs-2" "Remote Job Service"
                   73 "netrjs-3" "Remote Job Service"
                   74 "netrjs-4" "Remote Job Service"
                   75 "priv-dial" "Any private dial out service"
                   76 "deos" "Distributed External Object Store"
                   77 "priv-rje" "Any private RJE service"
                   78 "vettcp" "vettcp"
                   79 "finger" "Finger"
                   80 "www-http" "World Wide Web HTTP"
                   81 "hosts2-ns" "HOSTS2 Name Server"
                   82 "xfer" "XFER Utility"
                   83 "mit-ml-dev" "MIT ML Device"
                   84 "ctf" "Common Trace Facility"
                   85 "mit-ml-dev" "MIT ML Device"
                   86 "mfcobol" "Micro Focus Cobol"
                   87 "priv-term-l" "Any private terminal link"
                   88 "kerberos" "Kerberos"
                   89 "su-mit-tg" "SU/MIT Telnet Gateway"
                   90 "dnsix" "DNSIX Securit Attribute Token Map"
                   91 "mit-dov" "MIT Dover Spooler"
                   92 "npp" "Network Printing Protocol"
                   93 "dcp" "Device Control Protocol"
                   94 "objcall" "Tivoli Object Dispatcher"
                   95 "supdup" "SUPDUP"
                   96 "dixie" "DIXIE Protocol Specification"
                   97 "swift-rvf" "Swift Remote Vitural File Protocol"
                   98 "tacnews" "TAC News"
                   99 "metagram" "Metagram Relay"
                   100 "newacct" "[unauthorized use]"
                   101 "hostname" "NIC Host Name Server"
                   102 "iso-tsap" "ISO-TSAP Class 0"
                   103 "gppitnp" "Genesis Point-to-Point Trans Net"
                   104 "acr-nema" "ACR-NEMA Digital Imag. & Comm. 300"
                   105 "csnet-ns" "Mailbox Name Nameserver"
                   106 "epass" "Qualcomm Eudora password changing server"
                   107 "rtelnet" "Remote Telnet Service"
                   108 "snagas" "SNA Gateway Access Server"
                   109 "pop2" "Post Office Protocol - Version 2"
                   110 "pop3" "Post Office Protocol - Version 3"
                   111 "sunrpc" "SUN Remote Procedure Call"
                   112 "mcidas" "McIDAS Data Transmission Protocol"
                   113 "ident" "Identification Service"
                   114 "audionews" "Audio News Multicast"
                   115 "sftp" "Simple File Transfer Protocol"
                   116 "ansanotify" "ANSA REX Notify"
                   117 "uucp-path" "UUCP Path Service"
                   118 "sqlserv" "SQL Services"
                   119 "nntp" "Network News Transfer Protocol"
                   120 "cfdptkt" "CFDPTKT"
                   121 "erpc" "Encore Expedited Remote Pro.Call"
                   122 "smakynet" "SMAKYNET"
                   123 "ntp" "Network Time Protocol"
                   124 "ansatrader" "ANSA REX Trader"
                   125 "locus-map" "Locus PC-Interface Net Map Ser"
                   126 "unitary" "Unisys Unitary Login"
                   127 "locus-con" "Locus PC-Interface Conn Server"
                   128 "gss-xlicen" "GSS X License Verification"
                   129 "pwdgen" "Password Generator Protocol"
                   130 "cisco-fna" "Cisco FNATIVE"
                   131 "cisco-tna" "Cisco TNATIVE"
                   132 "cisco-sys" "Cisco SYSMAINT"
                   133 "statsrv" "Statistics Service"
                   134 "ingres-net" "INGRES-NET Service"
                   135 "loc-srv" "Location Service"
                   136 "profile" "PROFILE Naming System"
                   137 "netbios-ns" "NETBIOS Name Service"
                   138 "netbios-dgm" "NETBIOS Datagram Service"
                   139 "netbios-ssn" "NETBIOS Session Service"
                   140 "emfis-data" "EMFIS Data Service"
                   141 "emfis-cntl" "EMFIS Control Service"
                   142 "bl-idm" "Britton-Lee IDM"
                   143 "imap2" "Interim Mail Access Protocol v2"
                   144 "news" "NewS Window System"
                   145 "uaac" "UAAC Protocol"
                   146 "iso-tp0" "ISO-IP0"
                   147 "iso-ip" "ISO-IP"
                   148 "cronus" "CRONUS-SUPPORT"
                   149 "aed-512" "AED 512 Emulation Service"
                   150 "sql-net" "SQL-NET"
                   151 "hems" "HEMS"
                   152 "bftp" "Background File Transfer Program"
                   153 "sgmp" "SGMP"
                   154 "netsc-prod" "NETSC"
                   155 "netsc-dev" "NETSC"
                   156 "sqlsrv" "SQL Service"
                   157 "knet-cmp" "KNET/VM Command/Message Protocol"
                   158 "pcmail-srv" "PCMail Server"
                   159 "nss-routing" "NSS-Routing"
                   160 "sgmp-traps" "SGMP-TRAPS"
                   161 "snmp" "SNMP request port"
                   162 "snmptrap" "SNMP monitor trap port"
                   163 "cmip-man" "CMIP/TCP Manager"
                   164 "cmip-agent" "CMIP/TCP Agent"
                   165 "xns-courier" "Xerox"
                   166 "s-net" "Sirius Systems"
                   167 "namp" "NAMP"
                   168 "rsvd" "RSVD"
                   169 "send" "SEND"
                   170 "print-srv" "Network PostScript"
                   171 "multiplex" "Network Innovations Multiplex"
                   172 "cl/1" "Network Innovations CL/1"
                   173 "xyplex-mux" "Xyplex"
                   174 "mailq" "MAILQ"
                   175 "vmnet" "VMNET"
                   176 "genrad-mux" "GENRAD-MUX"
                   177 "xdmcp" "X Display Manager Control Protocol"
                   178 "nextstep" "NextStep Window Server"
                   179 "bgp" "Border Gateway Protocol"
                   180 "ris" "Intergraph"
                   181 "unify" "Unify"
                   182 "audit" "Unisys Audit SITP"
                   183 "ocbinder" "OCBinder"
                   184 "ocserver" "OCServer"
                   185 "remote-kis" "Remote-KIS"
                   186 "kis" "KIS Protocol"
                   187 "aci" "Application Communication Interface"
                   188 "mumps" "Plus Five's MUMPS"
                   189 "qft" "Queued File Transport"
                   190 "gacp" "Gateway Access Control Protocol"
                   191 "prospero" "Prospero Directory Service"
                   192 "osu-nms" "OSU Network Monitoring System"
                   193 "srmp" "Spider Remote Monitoring Protocol"
                   194 "irc" "Internet Relay Chat Protocol"
                   195 "dn6-nlm-aud" "DNSIX Network Level Module Audit"
                   196 "dn6-smm-red" "DNSIX Session Mgt Module Audit Redir"
                   197 "dls" "Directory Location Service"
                   198 "dls-mon" "Directory Location Service Monitor"
                   199 "smux" "SMUX"
                   200 "src" "IBM System Resource Controller"
                   201 "at-rtmp" "AppleTalk Routing Maintenance"
                   202 "at-nbp" "AppleTalk Name Binding"
                   203 "at-3" "AppleTalk Unused"
                   204 "at-echo" "AppleTalk Echo"
                   205 "at-5" "AppleTalk Unused"
                   206 "at-zis" "AppleTalk Zone Information"
                   207 "at-7" "AppleTalk Unused"
                   208 "at-8" "AppleTalk Unused"
                   209 "qmtp" "The Quick Mail Transfer Protocol"
                   210 "z39.50" "ANSI Z39.50"
                   211 "914c/g" "Texas Instruments 914C/G Terminal"
                   212 "anet" "ATEXSSTR"
                   213 "ipx" "IPX"
                   214 "vmpwscs" "VM PWSCS"
                   215 "softpc" "Insignia Solutions"
                   216 "CAIlic" "Computer Associates Int'l License Server"
                   217 "dbase" "dBASE Unix"
                   218 "mpp" "Netix Message Posting Protocol"
                   219 "uarps" "Unisys ARPs"
                   220 "imap3" "Interactive Mail Access Protocol v3"
                   221 "fln-spx" "Berkeley rlogind with SPX auth"
                   222 "rsh-spx" "Berkeley rshd with SPX auth"
                   223 "cdc" "Certificate Distribution Center"
                   242 "direct" "Direct"
                   243 "sur-meas" "Survey Measurement"
                   244 "dayna" "Dayna"
                   245 "link" "LINK"
                   246 "dsp3270" "Display Systems Protocol"
                   261 "nsiiops" "IIOP Name Service over TLS/SSL"
                   280 "http-mgmt" "http-mgmt"
                   309 "entrusttime" "EntrustTime"
                   344 "pdap" "Prospero Data Access Protocol"
                   345 "pawserv" "Perf Analysis Workbench"
                   346 "zserv" "Zebra server"
                   347 "fatserv" "Fatmen Server"
                   348 "csi-sgwp" "Cabletron Management Protocol"
                   349 "mftp" "mftp"
                   371 "clearcase" "Clearcase"
                   372 "ulistproc" "ListProcessor"
                   373 "legent-1" "Legent Corporation"
                   374 "legent-2" "Legent Corporation"
                   375 "hassle" "Hassle"
                   376 "nip" "Amiga Envoy Network Inquiry Proto"
                   377 "tnETOS" "NEC Corporation"
                   378 "dsETOS" "NEC Corporation"
                   379 "is99c" "TIA/EIA/IS-99 modem client"
                   380 "is99s" "TIA/EIA/IS-99 modem server"
                   381 "hp-collector" "HP performance data collector"
                   382 "hp-managed-node" "HP performance data managed node"
                   383 "hp-alarm-mgr" "HP performance data alarm manager"
                   384 "arns" "A Remote Network Server System"
                   385 "ibm-app" "IBM Application"
                   386 "asa" "ASA Message Router Object Def."
                   387 "aurp" "Appletalk Update-Based Routing Protocol"
                   388 "unidata-ldm" "Unidata LDM Version 4"
                   389 "entrustclient" "Entrustclient - NorTel DES auth network"
                   390 "uis" "UIS"
                   391 "synotics-relay" "SynOptics SNMP Relay Port"
                   392 "synotics-broker" "SynOptics Port Broker Port"
                   393 "dis" "Data Interpretation System"
                   394 "embl-ndt" "EMBL Nucleic Data Transfer"
                   395 "netcp" "NETscout Control Protocol"
                   396 "netware-ip" "Novell Netware over IP"
                   397 "mptn" "Multi Protocol Trans. Net."
                   398 "kryptolan" "Kryptolan"
                   399 "iso-tsap-c2" "ISO Transport Class 2 Non-Control over TCP"
                   400 "work-sol" "Workstation Solutions"
                   401 "ups" "Uninterruptible Power Supply"
                   402 "genie" "Genie Protocol"
                   403 "decap" "decap"
                   404 "nced" "nced"
                   405 "ncld" "ncld"
                   406 "imsp" "Interactive Mail Support Protocol"
                   407 "timbuktu" "Timbuktu"
                   408 "prm-sm" "Prospero Resource Manager Sys. Man."
                   409 "prm-nm" "Prospero Resource Manager Node Man."
                   410 "decladebug" "DECLadebug Remote Debug Protocol"
                   411 "rmt" "Remote MT Protocol"
                   412 "synoptics-trap" "Trap Convention Port"
                   413 "smsp" "SMSP"
                   414 "infoseek" "InfoSeek"
                   415 "bnet" "BNet"
                   416 "silverplatter" "Silverplatter"
                   417 "onmux" "Onmux"
                   418 "hyper-g" "Hyper-G"
                   419 "ariel1" "Ariel"
                   420 "smpte" "SMPTE"
                   421 "ariel2" "Ariel"
                   422 "ariel3" "Ariel"
                   423 "opc-job-start" "IBM Operations Planning and Control Start"
                   424 "opc-job-track" "IBM Operations Planning and Control Track"
                   425 "icad-el" "ICAD"
                   426 "smartsdp" "smartsdp"
                   427 "svrloc" "Server Location"
                   428 "ocs_cmu" "OCS_CMU"
                   429 "ocs_amu" "OCS_AMU"
                   430 "utmpsd" "UTMPSD"
                   431 "utmpcd" "UTMPCD"
                   432 "iasd" "IASD"
                   433 "nnsp" "NNSP"
                   434 "mobileip-agent" "MobileIP-Agent"
                   435 "mobilip-mn" "MobilIP-MN"
                   436 "dna-cml" "DNA-CML"
                   437 "comscm" "comscm"
                   438 "dsfgw" "dsfgw"
                   439 "dasp" "dasp"
                   440 "sgcp" "sgcp"
                   441 "decvms-sysmgt" "decvms-sysmgt"
                   442 "cvc_hostd" "cvc_hostd"
                   443 "https" "HTTP protocol over TLS/SSL"
                   444 "snpp" "Simple Network Paging Protocol"
                   445 "microsoft-ds" "Microsoft-DS"
                   446 "ddm-rdb" "DDM-RDB"
                   447 "ddm-dfm" "DDM-RFM"
                   448 "ddm-byte" "DDM-BYTE"
                   449 "as-servermap" "AS Server Mapper"
                   450 "tserver" "TServer"
                   451 "sfs-smp-net" "Cray Network Semaphore server"
                   452 "sfs-config" "Cray SFS config server"
                   453 "creativeserver" "CreativeServer"
                   454 "contentserver" "ContentServer"
                   455 "creativepartnr" "CreativePartnr"
                   456 "macon-tcp" "macon-tcp"
                   457 "scohelp" "scohelp"
                   458 "appleqtc" "Apple quick time"
                   459 "ampr-rcmd" "ampr-rcmd"
                   460 "skronk" "skronk"
                   461 "datasurfsrv" "DataRampSrv"
                   462 "datasurfsrvsec" "DataRampSrvSec"
                   463 "alpes" "alpes"
                   464 "kpasswd" "kpasswd"
                   465 "smtps" "SMTP protocol over TLS/SSL"
                   466 "digital-vrc" "digital-vrc"
                   467 "mylex-mapd" "mylex-mapd"
                   468 "photuris" "proturis"
                   469 "radio" "Radio Control Protocol (RCP)"
                   470 "scx-proxy" "scx-proxy"
                   471 "mondex" "Mondex"
                   472 "ljk-login" "ljk-login"
                   473 "hybrid-pop" "hybrid-pop"
                   474 "tn-tl-w1" "tn-tl-w1"
                   475 "tcpnethaspsrv" "tcpnethaspsrv"
                   476 "tn-tl-fd1" "tn-tl-fd1"
                   477 "ss7ns" "ss7ns"
                   478 "spsc" "spsc"
                   479 "iafserver" "iafserver"
                   480 "iafdbase" "iafdbase"
                   481 "ph" "Ph service"
                   482 "bgs-nsi" "bgs-nsi"
                   483 "ulpnet" "ulpnet"
                   484 "integra-sme" "Integra Software Management Environment"
                   485 "powerburst" "Air Soft Power Burst"
                   486 "avian" "avian"
                   487 "saft" "saft"
                   488 "gss-http" "gss-http"
                   489 "nest-protocol" "nest-protocol"
                   490 "micom-pfs" "micom-pfs"
                   491 "go-login" "go-login"
                   492 "ticf-1" "Transport Independent Convergence for FNA"
                   493 "ticf-2" "Transport Independent Convergence for FNA"
                   494 "pov-ray" "POV-Ray"
                   495 "intecourier" "intecourier"
                   496 "pim-rp-disc" "PIM-RP-DISC"
                   497 "dantz" "dantz"
                   498 "siam" "siam"
                   499 "iso-ill" "ISO ILL Protocol"
                   500 "isakmp" "isakmp"
                   501 "stmf" "STMF"
                   502 "asa-appl-proto" "asa-appl-proto"
                   503 "intrinsa" "Intrinsa"
                   504 "citadel" "citadel"
                   505 "mailbox-lm" "mailbox-lm"
                   506 "ohimsrv" "ohimsrv"
                   507 "crs" "crs"
                   508 "xvttp" "xvttp"
                   509 "snare" "snare"
                   510 "fcp" "FirstClass Protocol"
                   511 "mynet" "mynet-as"
                   512 "exec" "Remote process execution; log/pw auth"
                   513 "login" "Remote login [use Privileged Ports]"
                   514 "cmd" "Remote process; automatic auth [use PP]"
                   515 "printer" "Line printer spooler"
                   516 "videotex" "Monaco Telematique videotex"
                   517 "talk" "Talk [rendezvous source port]"
                   519 "utime" "Unixtime"
                   520 "efs" "LucasFilm Extended File Name Server"
                   521 "ripng" "ripng"
                   522 "ulp" "Microsoft ULP"
                   523 "ibm-db2" "IBM-DB2"
                   524 "ncp" "Novell NCP"
                   525 "timed" "Timeserver"
                   526 "tempo" "newdate"
                   527 "stx" "Stock IXChange"
                   528 "custix" "Customer IXChange"
                   529 "irc-serv" "IRC-SERV"
                   530 "courier" "rpc"
                   531 "conference" "chat"
                   532 "netnews" "readnews"
                   533 "netwall" "For emergency broadcasts"
                   534 "mm-admin" "MegaMedia Admin"
                   535 "iiop" "DEC iiop"
                   536 "opalis-rdv" "opalis-rdv"
                   537 "nmsp" "Networked Media Streaming Protocol"
                   538 "gdomap" "gdomap"
                   539 "apertus-ldp" "Apertus Technologies Load Determination"
                   540 "uucp" "Unix to Unix Copy Protocol"
                   541 "uucp-rlogin" "uucp-rlogin"
                   542 "commerce" "commerce"
                   543 "klogin" "Kerberos remote login (v4/v5)"
                   544 "kshell" "Kerberos remote shell (v4/v5)"
                   545 "appleqtcsrvr" "Apple quick time csrvr"
                   546 "dhcpv6-client" "DHCPv6 Client"
                   547 "dhcpv6-server" "DHCPv6 Server"
                   548 "afpovertcp" "Apple AFP over TCP"
                   549 "idfp" "Kovi IDFP"
                   550 "new-rwho" "New remote who"
                   551 "cybercash" "Cybercash"
                   552 "deviceshare" "deviceshare"
                   553 "pirp" "pirp"
                   555 "dsf" "dsf"
                   556 "remotefs" "Brunhoff Remote FileSystem Server"
                   557 "openvms-sysipc" "openvms-sysipc"
                   558 "sdnskmp" "SDNSKMP"
                   559 "teedtap" "TEEDTAP"
                   560 "rmonitor" "Remote monitor"
                   561 "monitor" "monitor"
                   563 "nntps" "NNTP protocol over TLS/SSL"
                   564 "9pfs" "Plan 9 File Service"
                   565 "whoami" "whoami"
                   566 "streettalk" "streettalk"
                   567 "banyan-rpc" "Banyan RPC"
                   568 "ms-shuttle" "Microsoft shuttle"
                   569 "ms-rome" "Microsoft rome"
                   572 "sonar" "sonar"
                   573 "banyan-vip" "Banyan VIP"
                   574 "ftp-agent" "FTP Software Agent System"
                   575 "vemmi" "VEMMI Videotex Enhanced Man Machine Interface"
                   576 "ipcd" "ipcd"
                   577 "vnas" "vnas"
                   578 "ipdd" "ipdd"
                   600 "ipcserver" "Sun IPC server"
                   606 "urm" "Cray Unified Resource Manager"
                   607 "nqs" "Cray Network Queuing System"
                   608 "sift-uft" "Sender-Initiated/Unsolicited File Transfer"
                   609 "npmp-trap" "npmp-trap"
                   610 "npmp-local" "npmp-local"
                   611 "npmp-gui" "npmp-gui"
                   633 "servstat" "Service Status update (Sterling Software)"
                   634 "ginad" "ginad"
                   635 "rlzdbase" "RLZ DBase"
                   636 "ldaps" "LDAP protocol over TLS/SSL"
                   637 "lanserver" "lanserver"
                   666 "doom" "doom Id Software"
                   667 "disclose" "campaign contribution disclosures SDR Tech."
                   668 "mecomm" "MeComm"
                   669 "meregister" "MeRegister"
                   670 "vacdsm-sws" "VACDSM-SWS"
                   671 "vacdsm-app" "VACDSM-APP"
                   672 "vpps-qua" "VPPS-QUA"
                   673 "cimplex" "CIMPLEX"
                   704 "elcsd" "errlog copy/server daemon"
                   709 "entrust-kmsh" "Entrust Key Management Service Handler"
                   710 "entrust-ash" "Entrust Administration Service Handler"
                   729 "netviewdm1" "IBM NetView DM/6000 Server/Client"
                   730 "netviewdm2" "IBM NetView DM/6000 send/tcp"
                   731 "netviewdm3" "IBM NetView DM/6000 receive/tcp"
                   740 "netcp" "NETscout Control Protocol [AXS2]"
                   741 "netgw" "netGW"
                   742 "netrcs" "Network based Rev. Cont. Sys."
                   744 "flexlm" "Flexible License Manager"
                   747 "fujitsu-dev" "Fujitsu Device Control"
                   748 "ris-cm" "Russell Info Sci Calendar Manager"
                   749 "kerberos-adm" "Kerberos administration"
                   750 "kerberos-iv" "Kerberos key server (v4)"
                   751 "kerberos_master" "Kerberos `kadmin' (v4)"
                   760 "krbupdate" "Kerberos (v4) registration"
                   761 "kpasswd" "Kerberos (v4) passwd"
                   781 "hp-collector" "HP performance data collector"
                   782 "hp-managed-node" "HP performance data managed node"
                   783 "hp-alarm-mgr" "HP performance data alarm manager"
                   786 "concert" "Concert"
                   871 "supfilesrv" "SUP File Server"
                   886 "iclcnet-locate" "ICL coNETion locate server"
                   887 "iclcnet_svinfo" "ICL coNETion server info"
                   888 "accessbuilder" "AccessBuilber"
                   911 "xact-backup" "xact-backup"
                   989 "ftps-data" "FTP protocol, data, over TLS/SSL"
                   990 "ftps" "FTP protocol, control, over TLS/SSL"
                   992 "telnets" "Telnet protocol over TLS/SSL"
                   993 "imaps" "IMAP4 protocol over TLS/SSL"
                   994 "ircs" "IRC protocol over TLS/SSL"
                   995 "pop3s" "POP3 protocol over TLS/SSL"
                   996 "vsinet" "vsinet"
                   1008 "ufsd" "UFS-aware server"
                   1025 "listen" "RFS remote_file_sharing"
                   1026 "nterm" "Network Terminal remote login"
                   1030 "iad1" "BBN IAD"
                   1031 "iad2" "BBN IAD"
                   1032 "iad3" "BBN IAD"
                   1047 "neod1" "Sun's NEO Object Request Broker"
                   1048 "neod2" "Sun's NEO Object Request Broker"
                   1058 "nim" "nim"
                   1059 "nimreg" "nimreg"
                   1067 "instl_boots" "Installation Bootstrap Proto. Serv."
                   1068 "instl_bootc" "Installation Bootstrap Proto. Cli."
                   1080 "socks" "Socks"
                   1083 "ansoft-lm-1" "Anasoft License Manager"
                   1084 "ansoft-lm-2" "Anasoft License Manager"
                   1110 "nfsd-status" "Cluster status info"
                   1155 "nfa" "Network File Access"
                   1212 "lupa" "lupa"
                   1222 "nerv" "SNI R&D network"
                   1346 "alta-ana-lm" "Alta Analytics License Manager"
                   1347 "bbn-mmc" "multi media conferencing"
                   1348 "bbn-mmx" "multi media conferencing"
                   1349 "sbook" "Registration Network Protocol"
                   1350 "editbench" "Registration Network Protocol"
                   1351 "equationbuilder" "Digital Tool Works"
                   1352 "lotusnote" "Lotus Note"
                   1353 "relief" "Relief Consulting"
                   1354 "rightbrain" "RightBrain Software"
                   1355 "intuitive" "Intuitive Edge"
                   1356 "cuillamartin" "CuillaMartin Company"
                   1357 "pegboard" "Electronic PegBoard"
                   1358 "connlcli" "CONNLCLI"
                   1359 "ftsrv" "FTSRV"
                   1360 "mimer" "MIMER"
                   1361 "linx" "LinX"
                   1362 "timeflies" "TimeFlies"
                   1363 "ndm-requester" "Network DataMover Requester"
                   1364 "ndm-server" "Network DataMover Server"
                   1365 "adapt-sna" "Network Software Associates"
                   1366 "netware-csp" "Novell NetWare Comm Service Platform"
                   1367 "dcs" "DCS"
                   1368 "screencast" "ScreenCast"
                   1369 "gv-us" "GlobalView to Unix Shell"
                   1370 "us-gv" "Unix Shell to GlobalView"
                   1371 "fc-cli" "Fujitsu Config Protocol"
                   1372 "fc-ser" "Fujitsu Config Protocol"
                   1373 "chromagrafx" "Chromagrafx"
                   1374 "molly" "EPI Software Systems"
                   1375 "bytex" "Bytex"
                   1376 "ibm-pps" "IBM Person to Person Software"
                   1377 "cichlid" "Cichlid License Manager"
                   1378 "elan" "Elan License Manager"
                   1379 "dbreporter" "Integrity Solutions"
                   1380 "telesis-licman" "Telesis Network License Manager"
                   1381 "apple-licman" "Apple Network License Manager"
                   1383 "gwha" "GW Hannaway Network License Manager"
                   1384 "os-licman" "Objective Solutions License Manager"
                   1385 "atex_elmd" "Atex Publishing License Manager"
                   1386 "checksum" "CheckSum License Manager"
                   1387 "cadsi-lm" "Computer Aided Design Software Inc LM"
                   1388 "objective-dbc" "Objective Solutions DataBase Cache"
                   1389 "iclpv-dm" "Document Manager"
                   1390 "iclpv-sc" "Storage Controller"
                   1391 "iclpv-sas" "Storage Access Server"
                   1392 "iclpv-pm" "Print Manager"
                   1393 "iclpv-nls" "Network Log Server"
                   1394 "iclpv-nlc" "Network Log Client"
                   1395 "iclpv-wsm" "PC Workstation Manager software"
                   1396 "dvl-activemail" "DVL Active Mail"
                   1397 "audio-activmail" "Audio Active Mail"
                   1398 "video-activmail" "Video Active Mail"
                   1399 "cadkey-licman" "Cadkey License Manager"
                   1400 "cadkey-tablet" "Cadkey Tablet Daemon"
                   1401 "goldleaf-licman" "Goldleaf License Manager"
                   1402 "prm-sm-np" "Prospero Resource Manager"
                   1403 "prm-nm-np" "Prospero Resource Manager"
                   1404 "igi-lm" "Infinite Graphics License Manager"
                   1405 "ibm-res" "IBM Remote Execution Starter"
                   1406 "netlabs-lm" "NetLabs License Manager"
                   1407 "dbsa-lm" "DBSA License Manager"
                   1408 "sophia-lm" "Sophia License Manager"
                   1409 "here-lm" "Here License Manager"
                   1410 "hiq" "HiQ License Manager"
                   1411 "af" "AudioFile"
                   1412 "innosys" "InnoSys"
                   1413 "innosys-acl" "Innosys-ACL"
                   1414 "ibm-mqseries" "IBM MQSeries"
                   1415 "dbstar" "DBStar"
                   1416 "novell-lu6.2" "Novell LU6.2"
                   1417 "timbuktu-srv1" "Timbuktu Service 1 Port"
                   1418 "timbuktu-srv2" "Timbuktu Service 2 Port"
                   1419 "timbuktu-srv3" "Timbuktu Service 3 Port"
                   1420 "timbuktu-srv4" "Timbuktu Service 4 Port"
                   1421 "gandalf-lm" "Gandalf License Manager"
                   1422 "autodesk-lm" "Autodesk License Manager"
                   1423 "essbase" "Essbase Arbor Software"
                   1424 "hybrid" "Hybrid Encryption Protocol"
                   1425 "zion-lm" "Zion Software License Manager"
                   1426 "sais" "Satellite-data Acquisition System 1"
                   1427 "mloadd" "mloadd monitoring tool"
                   1428 "informatik-lm" "Informatik License Manager"
                   1429 "nms" "Hypercom NMS"
                   1430 "tpdu" "Hypercom TPDU"
                   1431 "rgtp" "Reverse Gossip Transport"
                   1432 "blueberry-lm" "Blueberry Software License Manager"
                   1433 "ms-sql-s" "Microsoft-SQL-Server"
                   1434 "ms-sql-m" "Microsoft-SQL-Monitor"
                   1435 "ibm-cics" "IBM CICS"
                   1436 "saism" "Satellite-data Acquisition System 2"
                   1437 "tabula" "Tabula"
                   1438 "eicon-server" "Eicon Security Agent/Server"
                   1439 "eicon-x25" "Eicon X25/SNA Gateway"
                   1440 "eicon-slp" "Eicon Service Location Protocol"
                   1441 "cadis-1" "Cadis License Management"
                   1442 "cadis-2" "Cadis License Management"
                   1443 "ies-lm" "Integrated Engineering Software"
                   1444 "marcam-lm" "Marcam  License Management"
                   1445 "proxima-lm" "Proxima License Manager"
                   1446 "ora-lm" "Optical Research Associates License Manager"
                   1447 "apri-lm" "Applied Parallel Research LM"
                   1448 "oc-lm" "OpenConnect License Manager"
                   1449 "peport" "PEport"
                   1450 "dwf" "Tandem Distributed Workbench Facility"
                   1451 "infoman" "IBM Information Management"
                   1452 "gtegsc-lm" "GTE Government Systems License Man"
                   1453 "genie-lm" "Genie License Manager"
                   1454 "interhdl_elmd" "interHDL License Manager"
                   1455 "esl-lm" "ESL License Manager"
                   1456 "dca" "DCA"
                   1457 "valisys-lm" "Valisys License Manager"
                   1458 "nrcabq-lm" "Nichols Research Corp."
                   1459 "proshare1" "Proshare Notebook Application"
                   1460 "proshare2" "Proshare Notebook Application"
                   1461 "ibm_wrless_lan" "IBM Wireless LAN"
                   1462 "world-lm" "World License Manager"
                   1463 "nucleus" "Nucleus"
                   1464 "msl_lmd" "MSL License Manager"
                   1465 "pipes" "Pipes Platform"
                   1466 "oceansoft-lm" "Ocean Software License Manager"
                   1467 "csdmbase" "CSDMBASE"
                   1468 "csdm" "CSDM"
                   1469 "aal-lm" "Active Analysis Limited License Manager"
                   1470 "uaiact" "Universal Analytics"
                   1471 "csdmbase" "csdmbase"
                   1472 "csdm" "csdm"
                   1473 "openmath" "OpenMath"
                   1474 "telefinder" "Telefinder"
                   1475 "taligent-lm" "Taligent License Manager"
                   1476 "clvm-cfg" "clvm-cfg"
                   1477 "ms-sna-server" "Microsoft SNA server"
                   1478 "ms-sna-base" "Microsoft SNA base"
                   1479 "dberegister" "dberegister"
                   1480 "pacerforum" "PacerForum"
                   1481 "airs" "AIRS"
                   1482 "miteksys-lm" "Miteksys License Manager"
                   1483 "afs" "AFS License Manager"
                   1484 "confluent" "Confluent License Manager"
                   1485 "lansource" "LANSource"
                   1486 "nms_topo_serv" "nms_topo_serv"
                   1487 "localinfosrvr" "LocalInfoSrvr"
                   1488 "docstor" "DocStor"
                   1489 "dmdocbroker" "dmdocbroker"
                   1490 "insitu-conf" "insitu-conf"
                   1491 "anynetgateway" "anynetgateway"
                   1492 "stone-design-1" "stone-design-1"
                   1493 "netmap_lm" "netmap_lm"
                   1494 "ica" "ica"
                   1495 "cvc" "cvc"
                   1496 "liberty-lm" "liberty-lm"
                   1497 "rfx-lm" "rfx-lm"
                   1498 "watcom-sql" "Watcom-SQL"
                   1499 "fhc" "Federico Heinz Consultora"
                   1500 "vlsi-lm" "VLSI License Manager"
                   1501 "saiscm" "Satellite-data Acquisition System 3"
                   1502 "shivadiscovery" "Shiva"
                   1503 "imtc-mcs" "Databeam"
                   1504 "evb-elm" "EVB Software Engineering License Manager"
                   1505 "funkproxy" "Funk Software, Inc."
                   1506 "utcd" "Universal Time daemon (utcd)"
                   1507 "symplex" "symplex"
                   1508 "diagmond" "diagmond"
                   1509 "robcad-lm" "Robcad, Ltd. License Manager"
                   1510 "mvx-lm" "Midland Valley Exploration Ltd. Lic. Man."
                   1511 "3l-l1" "3l-l1"
                   1512 "wins" "Microsoft's Windows Internet Name Service"
                   1513 "fujitsu-dtc" "Fujitsu Systems Business of America, Inc"
                   1514 "fujitsu-dtcns" "Fujitsu Systems Business of America, Inc"
                   1515 "ifor-protocol" "ifor-protocol"
                   1516 "vpad" "Virtual Places Audio data"
                   1517 "vpac" "Virtual Places Audio control"
                   1518 "vpvd" "Virtual Places Video data"
                   1519 "vpvc" "Virtual Places Video control"
                   1520 "atm-zip-office" "atm zip office"
                   1521 "ncube-lm" "nCube License Manager"
                   1522 "ricardo-lm" "Ricardo North America License Manager"
                   1523 "cichild-lm" "cichild"
                   1524 "ingreslock" "Ingres"
                   1525 "prospero-np" "Prospero Directory Service non-priv"
                   1526 "pdap-np" "Prospero Data Access Prot non-priv"
                   1527 "tlisrv" "Oracle"
                   1528 "mciautoreg" "micautoreg"
                   1529 "coauthor" "Oracle"
                   1530 "rap-service" "rap-service"
                   1531 "rap-listen" "rap-listen"
                   1532 "miroconnect" "miroconnect"
                   1533 "virtual-places" "Virtual Places Software"
                   1534 "micromuse-lm" "micromuse-lm"
                   1535 "ampr-info" "ampr-info"
                   1536 "ampr-inter" "ampr-inter"
                   1537 "sdsc-lm" "isi-lm"
                   1538 "3ds-lm" "3ds-lm"
                   1539 "intellistor-lm" "Intellistor License Manager"
                   1540 "rds" "rds"
                   1548 "axon-lm" "Axon License Manager"
                   1549 "shivahose" "Shiva Hose"
                   1550 "3m-image-lm" "Image Storage license manager 3M Company"
                   1551 "hecmtl-db" "HECMTL-DB"
                   1553 "sna-cs" "sna-cs"
                   1554 "caci-lm" "CACI Products Company License Manager"
                   1555 "livelan" "livelan"
                   1556 "ashwin" "AshWin CI Tecnologies"
                   1557 "arbortext-lm" "ArborText License Manager"
                   1558 "xingmpeg" "xingmpeg"
                   1559 "web2host" "web2host"
                   1560 "asci-val" "asci-val"
                   1561 "facilityview" "facilityview"
                   1562 "pconnectmgr" "pconnectmgr"
                   1563 "cadabra-lm" "Cadabra License Manager"
                   1564 "pay-per-view" "Pay-Per-View"
                   1565 "winddlb" "WinDD"
                   1566 "corelvideo" "CORELVIDEO"
                   1567 "jlicelmd" "jlicelmd"
                   1568 "tsspmap" "tsspmap"
                   1569 "ets" "ets"
                   1570 "orbixd" "orbixd"
                   1571 "rdb-dbs-disp" "Oracle Remote Data Base"
                   1572 "chip-lm" "Chipcom License Manager"
                   1573 "itscomm-ns" "itscomm-ns"
                   1574 "mvel-lm" "mvel-lm"
                   1575 "oraclenames" "Oracle Names"
                   1576 "moldflow-lm" "moldflow-lm"
                   1577 "hypercube-lm" "hypercube-lm"
                   1578 "jacobus-lm" "Jacobus License Manager"
                   1579 "ioc-sea-lm" "ioc-sea-lm"
                   1580 "tn-tl-r1" "tn-tl-r1"
                   1581 "vmf-msg-port" "vmf-msg-port"
                   1582 "msims" "MSIMS"
                   1583 "simbaexpress" "simbaexpress"
                   1584 "tn-tl-fd2" "tn-tl-fd2"
                   1585 "intv" "intv"
                   1586 "ibm-abtact" "IBM abtact"
                   1587 "pra_elmd" "pra_elmd"
                   1588 "triquest-lm" "triquest-lm"
                   1589 "vqp" "VQP"
                   1590 "gemini-lm" "gemini-lm"
                   1591 "ncpm-pm" "ncpm-pm"
                   1592 "commonspace" "commonspace"
                   1593 "mainsoft-lm" "mainsoft-lm"
                   1594 "sixtrak" "sixtrak"
                   1595 "radio" "radio"
                   1596 "radio-sm" "radio-sm"
                   1597 "orbplus-iiop" "orbplus-iiop"
                   1598 "picknfs" "picknfs"
                   1599 "simbaservices" "simbaservices"
                   1600 "tnet" "Transputer net daemon"
                   1601 "aas" "Legent aas"
                   1602 "inspect" "inspect"
                   1603 "picodbc" "pickodbc"
                   1604 "icabrowser" "icabrowser"
                   1605 "slp" "Salutation Manager (Salutation Protocol)"
                   1606 "slm-api" "Salutation Manager (SLM-API)"
                   1607 "stt" "Microsoft stt"
                   1608 "smart-lm" "Smart Corp. License Manager"
                   1609 "isysg-lm" "isysg-lm"
                   1610 "taurus-wh" "taurus-wh"
                   1611 "ill" "Inter Library Loan"
                   1612 "netbill-trans" "NetBill Transaction Server"
                   1613 "netbill-keyrep" "NetBill Key Repository"
                   1614 "netbill-cred" "NetBill Credential Server"
                   1615 "netbill-auth" "NetBill Authorization Server"
                   1616 "netbill-prod" "NetBill Product Server"
                   1617 "nimrod-agent" "Nimrod Inter-Agent Communication"
                   1618 "skytelnet" "skytelnet"
                   1619 "xs-openstorage" "xs-openstorage"
                   1620 "faxportwinport" "faxportwinport"
                   1621 "softdataphone" "softdataphone"
                   1622 "ontime" "ontime"
                   1623 "jaleosnd" "jaleosnd"
                   1624 "udp-sr-port" "udp-sr-port"
                   1625 "svs-omagent" "svs-omagent"
                   1635 "radius-1" "Radius Authentication protocol"
                   1636 "cncp" "CableNet Control Protocol"
                   1637 "cnap" "CableNet Admin Protocol"
                   1638 "cnip" "CableNet Info Protocol"
                   1639 "cert-initiator" "cert-initiator"
                   1640 "cert-responder" "cert-responder"
                   1641 "invision" "InVision"
                   1642 "isis-am" "isis-am"
                   1643 "isis-ambc" "isis-ambc"
                   1644 "saiseh" "Satellite-data Acquisition System 4"
                   1645 "datametrics" "datametrics"
                   1646 "sa-msg-port" "sa-msg-port"
                   1647 "rsap" "rsap"
                   1648 "concurrent-lm" "concurrent-lm"
                   1649 "inspect" "inspect"
                   1650 "nkd" "nkd"
                   1651 "shiva_confsrvr" "shiva_confsrvr"
                   1652 "xnmp" "xnmp"
                   1653 "alphatech-lm" "alphatech-lm"
                   1654 "stargatealerts" "stargatealerts"
                   1655 "dec-mbadmin" "dec-mbadmin"
                   1656 "dec-mbadmin-h" "dec-mbadmin-h"
                   1657 "fujitsu-mmpdc" "fujitsu-mmpdc"
                   1658 "sixnetudr" "sixnetudr"
                   1659 "sg-lm" "Silicon Grail License Manager"
                   1660 "skip-mc-gikreq" "skip-mc-gikreq"
                   1661 "netview-aix-1" "netview-aix-1"
                   1662 "netview-aix-2" "netview-aix-2"
                   1663 "netview-aix-3" "netview-aix-3"
                   1664 "netview-aix-4" "netview-aix-4"
                   1665 "netview-aix-5" "netview-aix-5"
                   1666 "netview-aix-6" "netview-aix-6"
                   1667 "netview-aix-7" "netview-aix-7"
                   1668 "netview-aix-8" "netview-aix-8"
                   1669 "netview-aix-9" "netview-aix-9"
                   1670 "netview-aix-10" "netview-aix-10"
                   1671 "netview-aix-11" "netview-aix-11"
                   1672 "netview-aix-12" "netview-aix-12"
                   1673 "proshare-mc-1" "Intel Proshare Multicast"
                   1674 "proshare-mc-2" "Intel Proshare Multicast"
                   1675 "pdp" "Pacific Data Products"
                   1676 "netcomm1" "netcomm1"
                   1677 "groupwise" "groupwise"
                   1678 "prolink" "prolink"
                   1679 "darcorp-lm" "darcorp-lm"
                   1680 "microcom-sbp" ""
                   1681 "sd-elmd" "sd-elmd"
                   1682 "lanyon-lantern" "lanyon-lantern"
                   1683 "ncpm-hip" "ncpm-hip"
                   1684 "snaresecure" "SnareSecure"
                   1685 "n2nremote" "n2nremote"
                   1686 "cvmon" "cvmon"
                   1687 "nsjtp-ctrl" "nsjtp-ctrl"
                   1688 "nsjtp-data" "nsjtp-data"
                   1689 "firefox" "firefox"
                   1690 "ng-umds" "ng-umds"
                   1691 "empire-empuma" "empire-empuma"
                   1692 "sstsys-lm" "sstsys-lm"
                   1693 "rrirtr" "rrirtr"
                   1694 "rrimwm" "rrimwm"
                   1695 "rrilwm" "rrilwm"
                   1696 "rrifmm" "rrifmm"
                   1697 "rrisat" "rrisat"
                   1698 "rsvp-encap-1" "RSVP-ENCAPSULATION-1"
                   1699 "rsvp-encap-2" "RSVP-ENCAPSULATION-2"
                   1700 "mps-raft" "mps-raft"
                   1701 "l2f" "l2f"
                   1702 "deskshare" "deskshare"
                   1703 "hb-engine" "hb-engine"
                   1704 "bcs-broker" "bcs-broker"
                   1705 "slingshot" "slingshot"
                   1706 "jetform" "jetform"
                   1707 "vdmplay" "vdmplay"
                   1708 "gat-lmd" "gat-lmd"
                   1709 "centra" "centra"
                   1710 "impera" "impera"
                   1711 "pptconference" "pptconference"
                   1712 "registrar" "resource monitoring service"
                   1713 "conferencetalk" "ConferenceTalk"
                   1714 "sesi-lm" "sesi-lm"
                   1715 "houdini-lm" "houdini-lm"
                   1716 "xmsg" "xmsg"
                   1717 "fj-hdnet" "fj-hdnet"
                   1718 "h323gatedisc" "h323gatedisc"
                   1719 "h323gatestat" "h323gatestat"
                   1720 "h323hostcall" "h323hostcall"
                   1721 "caicci" "caicci"
                   1722 "hks-lm" "HKS License Manager"
                   1723 "pptp" "PPTP - Use also GRE"
                   1724 "csbphonemaster" "csbphonemaster"
                   1725 "iden-ralp" "iden-ralp"
                   1726 "iberiagames" "IBERIAGAMES"
                   1727 "winddx" "winddx"
                   1728 "telindus" "TELINDUS"
                   1729 "citynl" "CityNL License Management"
                   1730 "roketz" "roketz"
                   1731 "msiccp" "MSICCP"
                   1732 "proxim" "proxim"
                   1733 "sipat" "sipat"
                   1734 "cambertx-lm" "Camber Corporation License Management"
                   1735 "privatechat" "PrivateChat"
                   1736 "street-stream" "street-stream"
                   1737 "ultimad" "ultimad"
                   1738 "gamegen1" "GameGen1"
                   1739 "webaccess" "webaccess"
                   1740 "encore" "encore"
                   1741 "cisco-net-mgmt" "cisco-net-mgmt"
                   1742 "3Com-nsd" "3Com-nsd"
                   1743 "cinegrfx-lm" "Cinema Graphics License Manager"
                   1744 "ncpm-ft" "ncpm-ft"
                   1745 "remote-winsock" "remote-winsock"
                   1746 "ftrapid-1" "ftrapid-1"
                   1747 "ftrapid-2" "ftrapid-2"
                   1748 "oracle-em1" "Oracle em1"
                   1749 "aspen-services" "aspen-services"
                   1750 "sslp" "Simple Socket Library's PortMaster"
                   1751 "swiftnet" "SwiftNet"
                   1752 "lofr-lm" "Leap of Faith Research License Manager"
                   1753 "translogic-lm" "Translogic License Manager"
                   1754 "oracle-em2" "oracle-em2"
                   1755 "ms-streaming" "ms-streaming"
                   1756 "capfast-lmd" "capfast-lmd"
                   1757 "cnhrp" "cnhrp"
                   1758 "tftp-mcast" "tftp-mcast"
                   1759 "spss-lm" "SPSS License Manager"
                   1760 "www-ldap-gw" "www-ldap-gw"
                   1761 "cft-0" "cft-0"
                   1762 "cft-1" "cft-1"
                   1763 "cft-2" "cft-2"
                   1764 "cft-3" "cft-3"
                   1765 "cft-4" "cft-4"
                   1766 "cft-5" "cft-5"
                   1767 "cft-6" "cft-6"
                   1768 "cft-7" "cft-7"
                   1769 "bmc-net-adm" "bmc-net-adm"
                   1770 "bmc-net-svc" "bmc-net-svc"
                   1771 "vaultbase" "vaultbase"
                   1772 "essweb-gw" "EssWeb Gateway"
                   1773 "kmscontrol" "KMSControl"
                   1774 "global-dtserv" "global-dtserv"
                   1775 "199z" "[may be corrupted here]"
                   1776 "femis" "Federal Emergency Management Information Sys."
                   1777 "powerguardian" "powerguardian"
                   1778 "prodigy-internet" "prodigy-internet"
                   1779 "pharmasoft" "pharmasoft"
                   1780 "dpkeyserv" "dpkeyserv"
                   1781 "answersoft-lm" "answersoft-lm"
                   1782 "hp-hcip" "hp-hcip"
                   1783 "fjris" "Fujitsu Remote Install Service"
                   1784 "finle-lm" "Finle License Manager"
                   1785 "windlm" "Wind River Systems License Manager"
                   1786 "funk-logger" "funk-logger"
                   1787 "funk-license" "funk-license"
                   1788 "psmond" "psmond"
                   1789 "hello" "hello"
                   1790 "nmsp" "Narrative Media Streaming Protocol"
                   1791 "ea1" "EA1"
                   1792 "ibm-dt-2" "ibm-dt-2"
                   1793 "rsc-robot" "rsc-robot"
                   1794 "cera-bcm" "cera-bcm"
                   1795 "dpi-proxy" "dpi-proxy"
                   1796 "vocaltec-admin" "Vocaltec Server Administration"
                   1797 "uma" "UMA"
                   1798 "etp" "Event Transfer Protocol"
                   1799 "netrisk" "NETRISK"
                   1800 "ansys-lm" "ANSYS-License manager"
                   1801 "msmq" "Microsoft Message Que"
                   1802 "concomp1" "ConComp1"
                   1803 "hp-hcip-gwy" "HP-HCIP-GWY"
                   1804 "enl" "ENL"
                   1805 "enl-name" "ENL-Name"
                   1806 "musiconline" "Musiconline"
                   1807 "fhsp" "Fujitsu Hot Standby Protocol"
                   1808 "oracle-vp2" "Oracle VP2"
                   1809 "oracle-vp1" "Oracle VP1"
                   1810 "jerand-lm" "Jerand License Manager"
                   1811 "scientia-sdb" "Scientia-SDB"
                   1818 "etftp" "Enhanced Trivial File Transfer Protocol"
                   1819 "plato-lm" "Plato License Manager"
                   1820 "mcagent" "mcagent"
                   1821 "donnyworld" "donnyworld"
                   1822 "es-elmd" "es-elmd"
                   1823 "unisys-lm" "Unisys Natural Language License Manager"
                   1824 "metrics-pas" "metrics-pas"
                   1827 "smax" "SecureMax agent"
                   1901 "fjicl-tep-a" "Fujitsu ICL Terminal Emulator Program A"
                   1902 "fjicl-tep-b" "Fujitsu ICL Terminal Emulator Program B"
                   1903 "linkname" "Local Link Name Resolution"
                   1904 "fjicl-tep-c" "Fujitsu ICL Terminal Emulator Program C"
                   1911 "mtp" "Starlight Networks Multimedia Transport Prot."
                   1912 "as-lm" "Applied Statistics License Manager"
                   1913 "armadp" "armadp"
                   1944 "close-combat" "close-combat"
                   1945 "dialogic-elmd" "dialogic-elmd"
                   1946 "tekpls" "tekpls"
                   1947 "hlserver" "hlserver"
                   1948 "eye2eye" "eye2eye"
                   1949 "ismaeasdaqlive" "ISMA Easdaq Live"
                   1950 "ismaeasdaqtest" "ISMA Easdaq Test"
                   1951 "bcs-lmserver" "bcs-lmserver"
                   1985 "foliocorp" "Folio Remote Server"
                   1986 "licensedaemon" "Cisco license management"
                   1987 "tr-rsrb-p1" "Cisco RSRB Priority 1 port"
                   1988 "tr-rsrb-p2" "Cisco RSRB Priority 2 port"
                   1989 "mshnet" "MHSnet system"
                   1990 "stun-p1" "Cisco STUN Priority 1 port"
                   1991 "stun-p2" "Cisco STUN Priority 2 port"
                   1992 "ipsendmsg" "IPsendmsg"
                   1993 "snmp-tcp-port" "Cisco SNMP TCP port"
                   1994 "stun-port" "Cisco serial tunnel port"
                   1995 "perf-port" "Cisco perf port"
                   1996 "tr-rsrb-port" "Cisco Remote SRB port"
                   1997 "gdp-port" "Cisco Gateway Discovery Protocol"
                   1998 "x25-svc-port" "Cisco X.25 service (XOT)"
                   1999 "tcp-id-port" "Cisco identification port"
                   2005 "deslogin" "Encrypted symmetric telnet/login"
                   2033 "opirpc" "Basis"
                   2042 "isis" "Isis"
                   2043 "isis-bcast" "Isis-bcast"
                   2049 "nfs" "Networked File System - Sun Microsystems (cots)"
                   2065 "dlsrpn" "Data Link Switch Read Port Number"
                   2067 "dlswpn" "Data Link Switch Write Port Number"
                   2102 "zephyr-srv" "Zephyr server"
                   2103 "zephyr-clt" "Zephyr serv-hm connection"
                   2104 "zephyr-hm" "Zephyr hostmanager"
                   2105 "eklogin" "Kerberos (v4) encrypted rlogin"
                   2201 "ats" "Advanced Training System Program"
                   2213 "kali" "Kali"
                   2221 "unreg-ab1" "Allen-Bradley unregistered port"
                   2222 "datastar" "Datastar database"
                   2223 "inreg-ab3" "Allen-Bradley unregistered port"
                   2232 "ivs-video" "INRIA Videoconferencing System-Video default"
                   2234 "directplay" "DirectPlay"
                   2241 "ivsd" "INRIA IVS Daemon"
                   2279 "xmquery" "xmquery"
                   2280 "lnvpoller" "LNVPOLLER"
                   2281 "lnvconsole" "LNVCONSOLE"
                   2282 "lnvalarm" "LNVALARM"
                   2283 "lnvstatus" "LNVSTATUS"
                   2284 "lnvmaps" "LNVMAPS"
                   2285 "lnvmailmon" "LNVMAILMON"
                   2307 "pehelp" "pehelp"
                   2401 "cvspserver" "cvspserver"
                   2500 "rtsserv" "Resource Tracking system server"
                   2501 "rtsclient" "Resource Tracking system client"
                   2564 "hp-3000-telnet" "HP 3000 NS/VT block mode telnet"
                   2592 "netrek" "netrek"
                   2627 "webster" "webster dictionary server"
                   2700 "tqdata" "tqdata"
                   2766 "listen-v" "System V listener port"
                   2784 "www-dev" "World Wide Web - development"
                   2785 "aic-np" "aic-np"
                   2786 "aic-oncrpc" "aic-oncrpc - Destiny MCD database"
                   2787 "piccolo" "piccolo - Cornerstone Software"
                   2788 "fryeserv" "NetWare Loadable Module - Seagate Software"
                   2908 "mao" "Marc Baudoin Mao"
                   3000 "hbci" "HBCI"
                   3004 "firstclass" "FirstClass BBS"
                   3005 "deslogin" "Encrypted symmetric telnet/login"
                   3006 "deslogind" "Encrypted symmetric telnet/login"
                   3010 "gw" "Telerate Workstation"
                   3047 "hlserver" "Fast Security HL Server"
                   3048 "pctrader" "Sierra Net PC Trader"
                   3049 "cfs" "Cryptographic File System (nfs)"
                   3141 "vmodem" "VMODEM"
                   3264 "ccmail" "cc:mail/lotus"
                   3333 "dec-notes" "DEC Notes"
                   3421 "bmap" "Bull Apprise portmapper"
                   3454 "mira" "Apple Remote Access Protocol"
                   3455 "prsvp" "RSVP Port"
                   3456 "vat" "Visual Audio Tool default data"
                   3457 "vat-control" "VAT default control"
                   3462 "track" "software distribution"
                   3900 "udt_os" "Unidata UDT OS"
                   3984 "mapper-nodemgr" "MAPPER network node manager"
                   3985 "mapper-mapethd" "MAPPER TCP/IP server"
                   3986 "mapper-ws_ethd" "MAPPER workstation server"
                   4008 "netcheque" "NetCheque accounting"
                   4045 "lockd" "NFS lock"
                   4132 "nuts_dem" "NUTS Daemon"
                   4133 "nuts_bootp" "NUTS Bootp Server"
                   4144 "wincim" "pc windows compuserve.com protocol"
                   4321 "rwhois" "Remote Who Is"
                   4333 "msql" "mini-sql server"
                   4343 "unicall" "UNICALL"
                   4444 "nv-video" "Network Video Video default"
                   4500 "sae-urn" "sae-urn"
                   4501 "urn-x-cdchoice" "urn-x-cdchoice"
                   4557 "fax" "FlexFax FAX transmission service"
                   4672 "rfa" "Remote File Access Server"
                   5002 "rfe" "Radio Free Ethernet"
                   5003 "claris-fmpro" "Claris FileMaker Pro"
                   5004 "avt-profile-1" "avt-profile-1"
                   5005 "avt-profile-2" "avt-profile-2"
                   5010 "telelpathstart" "TelepathStart"
                   5011 "telelpathattack" "TelepathAttack"
                   5020 "zenginkyo-1" "zenginkyo-1"
                   5021 "zenginkyo-2" "zenginkyo-2"
                   5050 "mmcc" "multimedia conference control tool"
                   5190 "eworld" "goto.eworld.com PC <-> eworld protocol"
                   5191 "aol-1" "AmericaOnline1"
                   5192 "aol-2" "AmericaOnline2"
                   5193 "aol-3" "AmericaOnline3"
                   5232 "sgi-dgl" "SGI Distributed Graphics"
                   5300 "hacl-hb" "HA cluster heartbeat"
                   5301 "hacl-gs" "HA cluster general services"
                   5302 "hacl-cfg" "HA cluster configuration"
                   5303 "hacl-probe" "HA cluster probing"
                   5304 "hacl-local" "HA cluster local"
                   5305 "hacl-test" "HA cluster Test"
                   5432 "postgres" "Postgres SQL"
                   5444 "netplan" "Netplan distributed agenda"
                   5631 "pcanywheredata" "pcANYWHEREdata"
                   5632 "pcanywherestat" "pcANYWHEREstat"
                   5678 "rrac" "Remote Replication Agent Connection"
                   5679 "dccm" "Direct Cable Connect Manager"
                   5713 "proshareaudio" "proshare conf audio"
                   5714 "prosharevideo" "proshare conf video"
                   5715 "prosharedata" "proshare conf data"
                   5716 "prosharerequest" "proshare conf request"
                   5717 "prosharenotify" "proshare conf notify"
                   5729 "openmail" "HP Open-mail"
                   5745 "fcopy-server" "fcopy-server"
                   5977 "ncd-pref-tcp" "NCD preferences tcp port"
                   5978 "ncd-diag-tcp" "NCD diagnostic tcp port"
                   5979 "ncd-conf-tcp" "NCD configuration tcp port"
                   5997 "ncd-pref" "NCD preferences telnet port"
                   5998 "ncd-diag" "NCD diagnostic telnet port"
                   5999 "ncd-conf" "NCD configuration telnet port"
                   6000 "xwindow" "X11 protocol on device 0"
                   6110 "softcm" "HP SoftBench CM"
                   6111 "sub-process" "HP SoftBench Sub-Process Control"
                   6112 "dtspcd" "CDE subprocess control"
                   6141 "meta-corp" "Meta Corporation License Manager"
                   6142 "aspentec-lm" "Aspen Technology License Manager"
                   6143 "watershed-lm" "Watershed License Manager"
                   6144 "statsci1-lm" "StatSci License Manager - 1"
                   6145 "statsci2-lm" "StatSci License Manager - 2"
                   6146 "lonewolf-lm" "Lone Wolf Systems License Manager"
                   6147 "montage-lm" "Montage License Manager"
                   6148 "ricardo-lm" "Ricardo North America License Manager"
                   6149 "tal-pod" "tal-pod"
                   6253 "crip" "CRIP"
                   6389 "clariion-evr01" "clariion-evr01"
                   6455 "skip-cert-recv" "SKIP Certificate Receive"
                   6456 "skip-cert-send" "SKIP Certificate Send"
                   6558 "xdsxdm" "xdsxdm"
                   6666 "irc-serv" "Internet Relay Chat server"
                   6667 "irc-6667" "Internet Relay Chat"
                   6670 "vocaltec-gold" "Vocaltec Global Online Directory"
                   6672 "vision_server" "vision_server"
                   6673 "vision_elmd" "vision_elmd"
                   6831 "ambit-lm" "ambit-lm"
                   6969 "acmsoda" "acmsoda"
                   7000 "dos" "MS/DOS"
                   7001 "afs3-callback" "callbacks to cache managers"
                   7002 "afs3-prserver" "users & groups database"
                   7003 "afs3-vlserver" "volume location database"
                   7004 "afs3-kaserver" "AFS/Kerberos authentication service"
                   7005 "afs3-volser" "volume managment server"
                   7006 "afs3-errors" "error interpretation service"
                   7007 "afs3-bos" "basic overseer process"
                   7008 "afs3-update" "server-to-server updater"
                   7009 "afs3-rmtsys" "remote cache manager service"
                   7010 "ups-onlinet" "onlinet uninterruptable power supplies"
                   7070 "realaudio" "RealAudio"
                   7099 "lazy-ptop" "lazy-ptop"
                   7100 "dorosave" "Dorotech Dorosave"
                   7121 "virprot-lm" "Virtual Prototypes License Manager"
                   7200 "fodms" "FODMS FLIP"
                   7201 "dlip" "DILP"
                   7395 "winqedit" "winqedit"
                   7491 "telops-lmd" "telops-lmd"
                   7511 "pafec-lm" "pafec-lm"
                   7777 "cbt" "cbt"
                   7781 "accu-lmgr" "accu-lmgr"
                   7999 "irdmi2" "iRDMI2"
                   8000 "http8000" "HTTP in proxy use on port 8000"
                   8080 "http-relay" "HTTP in proxy use"
                   8450 "npmp" "npmp"
                   8888 "ddi-tcp-1" "NewsEDGE server TCP (TCP 1)"
                   8889 "ddi-tcp-2" "Desktop Data TCP 1"
                   8890 "ddi-tcp-3" "Desktop Data TCP 2"
                   8891 "ddi-tcp-4" "Desktop Data TCP 3: NESS application"
                   8892 "ddi-tcp-5" "Desktop Data TCP 4: FARM product"
                   8893 "ddi-tcp-6" "Desktop Data TCP 5: NewsEDGE/Web application"
                   8894 "ddi-tcp-7" "Desktop Data TCP 6: COAL application"
                   9000 "cslistener" "CSlistener"
                   9875 "nftp" "Solsoft standard FTP"
                   9876 "sd" "Session Directory"
                   9998 "distinct32" "Distinct32"
                   9999 "distinct" "Distinct"
                   10000 "ndmp" "Network Data Management Protocol"
                   10005 "stel" "Secure telnet"
                   10021 "ftp-proxy" "TIS Firewall Toolkit FTP proxy"
                   10023 "tn-proxy" "TIS Firewall Toolkit Telnet proxy"
                   12753 "tsaf" "tsaf port"
                   15232 "zpop" "Zmail Post Office Protocol"
                   17007 "isode-dua" "Isode-DUA"
                   18000 "biimenu" "Beckman Instruments, Inc."
                   21845 "webphone" "webphone"
                   21846 "netspeak-is" "NetSpeak Corp. Directory Services"
                   21847 "netspeak-cs" "NetSpeak Corp. Connection Services"
                   21848 "netspeak-acd" "NetSpeak Corp. Automatic Call Distribution"
                   21849 "netspeak-cps" "NetSpeak Corp. Credit Processing System"
                   22273 "wnn6" "wnn6"
                   22555 "vocaltec-wconf" "Vocaltec Web Conference"
                   22800 "aws-brf" "Telerate Information Platform LAN"
                   22951 "brf-gw" "Telerate Information Platform WAN"
                   25000 "icl-twobase1" "icl-twobase1"
                   25001 "icl-twobase2" "icl-twobase2"
                   25002 "icl-twobase3" "icl-twobase3"
                   25003 "icl-twobase4" "icl-twobase4"
                   25004 "icl-twobase5" "icl-twobase5"
                   25005 "icl-twobase6" "icl-twobase6"
                   25006 "icl-twobase7" "icl-twobase7"
                   25007 "icl-twobase8" "icl-twobase8"
                   25008 "icl-twobase9" "icl-twobase9"
                   25009 "icl-twobase10" "icl-twobase10"
                   25793 "vocaltec-hos" "Vocaltec Address Server"
                   26000 "quake" "quake"
                   26208 "wnn6-ds" "wnn6-ds"
                   32771 "sunrpc2" "Rpcbind bis"
                   40620 "fix" "Fidelity Investment Exchange"
                   47557 "dbbrowse" "Databeam Corporation"
                   47806 "ap" "ALC Protocol"
                   47808 "bacnet" "Building Automation and Control Networks"
			   }
        default = 7
        help = "source port"
    }

    field -dest @ (2, 2) = {
        type = samelist(-src)
        default = 7
        help = "destination port"
    }

    field -sequence @ (4, 4) = {
        type = integer
        help = "sequence number (if SYN is present, it is the initial sequence number)"
    }

    field -acknowledge @ (8, 4) = {
        type = integer
        help = "acknowledge number"
    }

    field -dataoffset @ (12, 0.4) = {
        type = integer
        default = 5
        help = "number of DWORD in the header, so offset to the data"
    }

    field -reserved @ (12.4, 0.6) = {
        type = integer
        default = 0
        help = "reserved for future use. Must be zero"
    }

    field -flags @ (13.2, 0.6) = {
        type = flags { 
					0x20 "urg" "no urgent field" "urgent Pointer field significant"
                    0x10 "ack"  "no acknowledgment field" "acknowledgment field significant"
                    0x08 "psh"  "no push" "push function"
                    0x04 "rst"  "normal" "reset the connection"
                    0x02 "syn"  "normal" "synchronise sequence number"
                    0x01 "fin"  "normal" "no more data from sender"
			   }
        default = 0
        help = "flags (fragmentation)"
    }

    field -window @ (14, 2) = {
        type = integer
        help = "number of data octets the sender of this segment is willing to accept"
    }

    field -checksum @ (16, 2) = {
        type = checksum(tcp)
        help = "the checksum (0 means no checksum generated), for header and data"
    }

    field -urgent @ (18, 2) = {
        type = integer
        help = "current value of the urgent pointer as a positive offset from the sequence number in this segment (if URG flag set)"
    }

    field -options @ (20, 0) = {
        type = integer # tcp_option
		help = "list of TCP options"
    }
}
