#-------------------------------------------------------------------------------------------------
#   DNS
#-------------------------------------------------------------------------------------------------

protocol domain = {
	spec = "RFC 1034-5"
    size = '%computedsize'

	field -id @ (0, 2) = {
        type = integer
        help = "identification"
    }

	#---- Flags
	field -qr @ (2, 0.1) = {
        type = flags { 0x01 "response" "query" "response" }
		default = 0
        help = "message type"
    }

	field -opcode @ (2.1, 0.4) = {
        type = list {  
                   0 "query" "a standard query"
                   1 "iquery" "an inverse query"
                   2 "status" "a server status request"
                   other "reserved" "reserved for future use"
			   }
		default = 0
        help = "kind of query of the message (set by originator, copied in response)"
    }

    field -flags @ (2.5, 0.4) = {
        type = flags { 0x08 "aa"  "not authoritative" "authoritative answer"
                       0x04 "tc"  "not truncated" "truncated"
                       0x02 "rd"  "no recursion desired" "recusion desired"
                       0x01 "ra"  "recursion unavailable" "recursion available" }
        default = 0
        help = "flags about message"
    }

	field -zero @ (2.9, 0.3) = {
        type = integer
		default = 0
        help = "reserved fur future use"
    }

	field -rcode @ (2.12, 0.4) = {
        type = list {  
                   0 "ok" "no error condition"
                   1 "format" "format error"
                   2 "server" "server failure"
                   3 "name" "name error, domain does not exist"
                   4 "implemented" "not implemented"
                   5 "refused" "refused for policy reasons"
                   other "reserved" "reserved for future use"
			   }
		default = 0
        help = "response code"
    }

	#---- Number of records
	field -nbquery @ (4, 2) = {
        type = integer
        help = "number of query records"
		read-only
    }
	field -nbanswer @ (6, 2) = {
        type = integer
        help = "number of answer records"
    }
	field -nbauthority @ (8, 2) = {
        type = integer
        help = "number of authority records"
    }
	field -nbadditional @ (10, 2) = {
        type = integer
        help = "number of additional records"
    }

	# Queries
    fieldarray -query @ (12, '%variable') = {
		nbelements = '%field(-nbquery)'
        type = mapper(dns_query)
        help = "queries"
		read-only
    }
	# Answers
    fieldarray -answer @ ('%follows', '%variable') = {
		nbelements = '%field(-nbanswer)'
        type = mapper(dns_answer)
        help = "answers"
    }
	# Authority
    fieldarray -authority @ ('%follows', '%variable') = {
		nbelements = '%field(-nbauthority)'
        type = mapper(dns_answer)
        help = "authority"
    }
	# Additional
    fieldarray -additional @ ('%follows', '%variable') = {
		nbelements = '%field(-nbadditional)'
        type = mapper(dns_answer)
        help = "additional"
    }
}


protocol dns_query = {
	spec = "RFC 1034-5"
    size = '%computedsize'
	read-only


    field -name @ (0, '%variable') = {
        type = string(dns)
        help = "question name"
    }

    field -type @ ('%follows', 2) = {
        type = sparelist {
				    1 "A" "host address"
				    2 "NS" "authoritative name server"
				    3 "MD" "mail destination (Obsolete - use MX)"
				    4 "MF" "mail forwarder (Obsolete - use MX)"
				    5 "CNAME" "canonical name for an alias"
				    6 "SOA" "marks the start of a zone of authority"
				    7 "MB" "mailbox domain name (EXPERIMENTAL)"
				    8 "MG" "mail group member (EXPERIMENTAL)"
				    9 "MR" "mail rename domain name (EXPERIMENTAL)"
				   10 "NULL" "null RR (EXPERIMENTAL)"
				   11 "WKS" "well known service description"
				   12 "PTR" "domain name pointer"
				   13 "HINFO" "host information"
				   14 "MINFO" "mailbox or mail list information"
				   15 "MX" "mail exchange"
				   16 "TXT" "text strings"
				  252 "AXFR" "request for a transfer of an entire zone"
				  253 "MAILB" "request for mailbox-related records (MB, MG or MR)"
				  254 "MAILA" "request for mail agent RRs (Obsolete - see MX)"
				  255 "*" "request for all records"
			   }
        help = "type of question"
    }

    field -class @ ('%follows', 2) = {
        type = sparelist {
				   1 "IN" "Internet"
				   2 "CS" "CSNET class (Obsolete - used only for examples in some obsolete RFCs)"
				   3 "CH" "CHAOS class"
				   4 "HS" "Hesiod [Dyer 87]"
				   255 "*" "any class"
			   }
        help = "class of question"
    }
}

protocol dns_answer = {
	spec = "RFC 1034-5"
    size = '%computedsize'


    field -name @ (0, '%variable') = {
        type = string(dns)
        help = "question name"
    }

    field -type @ ('%follows', 2) = {
        type = list {
				    1 "A" "host address"
				    2 "NS" "authoritative name server"
				    3 "MD" "mail destination (Obsolete - use MX)"
				    4 "MF" "mail forwarder (Obsolete - use MX)"
				    5 "CNAME" "canonical name for an alias"
				    6 "SOA" "marks the start of a zone of authority"
				    7 "MB" "mailbox domain name (EXPERIMENTAL)"
				    8 "MG" "mail group member (EXPERIMENTAL)"
				    9 "MR" "mail rename domain name (EXPERIMENTAL)"
				   10 "NULL" "null RR (EXPERIMENTAL)"
				   11 "WKS" "well known service description"
				   12 "PTR" "domain name pointer"
				   13 "HINFO" "host information"
				   14 "MINFO" "mailbox or mail list information"
				   15 "MX" "mail exchange"
				   16 "TXT" "text strings"
			   }
        help = "type of question"
    }

    field -class @ ('%follows', 2) = {
        type = list {
				   1 "IN" "Internet"
				   2 "CS" "CSNET class (Obsolete - used only for examples in some obsolete RFCs)"
				   3 "CH" "CHAOS class"
				   4 "HS" "Hesiod [Dyer 87]"
			   }
        help = "class of question"
    }

    field -ttl @ ('%follows', 4) = {
        type = integer
        help = "time to live"
    }

    field -datalength @ ('%follows', 2) = {
        type = integer
        help = "length of data"
    }

    field -data @ ('%follows', '%seek(-2,2)') = {
        type = switch('%seek(-10, 2)') {
				   1		address_ip
			       12		string(dns)
				   default	string(fixed)
			   }
        help = "data"
    }
}
