#include "ippacket.h"
#include <menu.h>
int gen_menu(ITEM **, int);	/* ITEM defined in menu.h */


static void tcp_menu(struct str_args *);
static void udp_menu(struct str_args *);
static void icmp_menu(struct str_args *);
static void icmptype_menu(struct str_args *);
static void tcpflags_menu(struct str_args *);
void make_border(WINDOW *);


int gen_menu(ITEM ** items, int numitems)
{
    MENU *m;
    WINDOW *w = newwin(15, 70, 10, 0);
    int cur_item = 0, c;

    m = new_menu(items);
    set_menu_win(m, w);
    make_border(w);
    for (;;)
      {
	  post_menu(m);
	  set_current_item(m, items[cur_item]);
	  touchwin(w);
	  wrefresh(w);
	  c = getch();
	  if (c == KEY_UP)
	    {
		if (cur_item <= 0)
		    cur_item = numitems;
		else
		    cur_item--;
	    }
	  if (c == KEY_DOWN)
	    {
		if (cur_item >= numitems)
		    cur_item = 0;
		else
		    cur_item++;
	    }
	  if (c == KEY_RIGHT)
	    {
		delwin(w);
		free_menu(m);
		return cur_item;
	    }
	  usleep(5555);
      }
    return 0;
}



static void tcp_menu(struct str_args *args)
{
    char str[30];
    ITEM **items = calloc(sizeof(ITEM), 10);

    items[0] = new_item("return to proto menu", "blah");
    items[1] = new_item("source port", "tcp src port");
    items[2] = new_item("dest. port", "tcp dest port");
    items[3] = new_item("urgpointer", "tcp urgpointer");
    items[4] = new_item("window size", "tcp window size");
    items[5] = new_item("tcpflag(s)", "blah");
    items[6] = NULL;

    switch (gen_menu(items, 5))
      {
      case 1:
	  popupandread("enter tcp source port:", str);
	  args->tcp.s_port = atoi(str);
	  break;
      case 2:
	  popupandread("enter tcp dest. port:", str);
	  args->tcp.d_port = atoi(str);
	  break;
      case 3:
	  popupandread("enter tcp urgpointer", str);
	  args->tcp.urgpoint = atoi(str);
	  break;
      case 4:
	  popupandread("enter tcp window size", str);
	  args->tcp.win = atoi(str);
	  break;
      case 5:
	  tcpflags_menu(args);
      }
    free(items);
}


static void udp_menu(struct str_args *args)
{
    char str[30];
    ITEM **items = calloc(sizeof(ITEM), 4);

    items[0] = new_item("return to proto menu", "blah");
    items[1] = new_item("source port", "udp src port");
    items[2] = new_item("dest. port", "udp dest port");
    items[3] = NULL;
    switch (gen_menu(items, 2))
      {
      case 1:
	  popupandread("enter udp source port:", str);
	  args->udp.s_port = atoi(str);
	  break;
      case 2:
	  popupandread("enter udp dest port:", str);
	  args->udp.d_port = atoi(str);
	  break;
      }
    free(items);
}

/* only one choice for now */
static void icmp_menu(struct str_args *args)
{
    ITEM **items = calloc(sizeof(ITEM), 3);

    items[0] = new_item("return to proto menu", "blah");
    items[1] = new_item("icmp type", "blah");
    items[2] = NULL;
    switch (gen_menu(items, 2))
      {
      case 1:
	  icmptype_menu(args);
	  break;
      }
    free(items);
}

static void icmptype_menu(struct str_args *args)
{
    ITEM **items = calloc(sizeof(ITEM), 15);

    items[0] = new_item("return to proto menu", "blah");
    items[1] = new_item("ICMP_ECHOREPLY", "tcp");
    items[2] = new_item("ICMP_DEST_UNREACH", "tcp");
    items[3] = new_item("ICMP_SOURCE_QUENCH", "tcp");
    items[4] = new_item("ICMP_REDIRECT", "tcp");
    items[5] = new_item("ICMP_ECHO", "blah");
    items[6] = new_item("ICMP_TIME_EXCEEDED", "blah");
    items[7] = new_item("ICMP_PARAMETERPROB", "blah");
    items[8] = new_item("ICMP_TIMESTAMP", "blah");
    items[9] = new_item("ICMP_TIMESTAMPREPLY", "blah");
    items[10] = new_item("ICMP_INFO_REQUEST", "blah");
    items[11] = new_item("ICMP_INFO_REPLY", "blah");
    items[12] = new_item("ICMP_ADDRESS", "blah");
    items[13] = new_item("ICMP_ADDRESSREPLY", "blah");
    items[14] = NULL;
    switch (gen_menu(items, 14))
      {
      case 1:
	  args->icmptype = ICMP_ECHOREPLY;
	  break;
      case 2:
	  args->icmptype = ICMP_DEST_UNREACH;
	  break;
      case 3:
	  args->icmptype = ICMP_SOURCE_QUENCH;
	  break;
      case 4:
	  args->icmptype = ICMP_REDIRECT;
	  break;
      case 5:
	  args->icmptype = ICMP_ECHO;
	  break;
      case 6:
	  args->icmptype = ICMP_TIME_EXCEEDED;
	  break;
      case 7:
	  args->icmptype = ICMP_PARAMETERPROB;
	  break;
      case 8:
	  args->icmptype = ICMP_TIMESTAMP;
	  break;
      case 9:
	  args->icmptype = ICMP_TIMESTAMPREPLY;
	  break;
      case 10:
	  args->icmptype = ICMP_INFO_REQUEST;
	  break;
      case 11:
	  args->icmptype = ICMP_INFO_REPLY;
	  break;
      case 12:
	  args->icmptype = ICMP_ADDRESS;
	  break;
      case 13:
	  args->icmptype = ICMP_ADDRESSREPLY;
	  break;
      }
    free(items);
}

static void tcpflags_menu(struct str_args *args)
{
    ITEM **items = calloc(sizeof(ITEM), 7);

    for (;;)
      {				/* these have to be in the loop or it fuxors the 2nd time around?!@ */
	  items[0] = new_item("return to proto menu", "blah");
	  items[1] = new_item("TH_ACK", "select all flags you are using then return");
	  items[2] = new_item("TH_SYN", "tcp");
	  items[3] = new_item("TH_RST", "tcp");
	  items[4] = new_item("TH_PUSH", "tcp");
	  items[5] = new_item("TH_URG", "blah");
	  items[6] = new_item("TH_FIN", "blah");
	  items[7] = NULL;
	  switch (gen_menu(items, 7))
	    {
	    case 0:
		free(items);
		return;
	    case 1:
		args->tcp.flags |= TH_ACK;
		args->tcp.def_flag = 0;
		break;
	    case 2:
		args->tcp.flags |= TH_SYN;
		args->tcp.def_flag = 0;
		break;
	    case 3:
		args->tcp.flags |= TH_RST;
		args->tcp.def_flag = 0;
		break;
	    case 4:
		args->tcp.flags |= TH_PUSH;
		args->tcp.def_flag = 0;
		break;
	    case 5:
		args->tcp.flags |= TH_URG;
		args->tcp.def_flag = 0;
		break;
	    case 6:
		args->tcp.flags |= TH_FIN;
		args->tcp.def_flag = 0;
		break;
	    }
      }
}

void proto_menu(struct str_args *args, struct iphdr *ip_header)
{
    ITEM **items = calloc(sizeof(ITEM), 10);

    for (;;)
      {
	  items[0] = new_item("return to main menu", "blah");
	  items[1] = new_item("IPPROTO_ICMP", "icmp");
	  items[2] = new_item("IPPROTO_TCP", "tcp");
	  items[3] = new_item("IPPROTO_UDP", "udp");
	  items[4] = new_item("IPPROTO_RAW", "default");
	  items[5] = NULL;
	  switch (gen_menu(items, 4))
	    {
	    case 0:
		free(items);
		return;
	    case 1:
		ip_header->protocol = IPPROTO_ICMP;
		icmp_menu(args);
		break;
	    case 2:
		ip_header->protocol = IPPROTO_TCP;
		tcp_menu(args);
		break;
	    case 3:
		ip_header->protocol = IPPROTO_UDP;
		udp_menu(args);
		break;
	    case 4:
		ip_header->protocol = IPPROTO_RAW;
		free(items);
		return;
	    }
      }
}
