#include "ippacket.h"


void
 main(int argc, char *argv[])
{
    struct str_args args;
    char *packet = malloc(5555);	/* wuteva */
    struct iphdr *ip_header = malloc(sizeof(struct iphdr));	/* from <linux/ip.h> */

    if (getuid() && geteuid())
      {
	  printf("Must be run as root or as a setuid file\n");
	  exit(-1);
      }
    if (argc == 1)
      {
	  printf("%s <-N> [-p protocol <proto_options>]\n"
	  "If -N is first arg, the program will be run in ncurses mode\n"
		 "ALL:\n"
		 "-s source_ip\n-d dest_ip\n"
		 "-I IP identification (random)\n"
		 "-T IP ttl (60)\n"
		 "-D data to add to end of any type of packet\n"
		 "-W write outgoing packet to file\n"
		 "-p protocol  (IPPROTO_RAW) -p '?' shows other available protocols\n"
		 "-r <num> (1) -r -1 will repeat packet send forever, else repeat num times\n"
		 "TCP and UDP:\n"
		 "-x udp/tcp source port (7777)\n"
		 "-y udp/tcp destination port (7778)\n"
		 "TCP only:\n"
	     "-f TCP flags (TH_FIN) -f '?' shows other available flags\n"
		 "-u urgent pointer (0) use with -f TH_URG   TCP\n"
		 "-w tcp window size (512)   TCP\n"
		 "-q tcp sequence number size (0)   TCP\n"
		 "-a tcp ack number size (0)   TCP\n"
		 "ICMP only:\n"
	  "-i ICMP type (ICMP_ECHO) -i '?' shows other available types\n"
		 "ippacket v2.0 by Sean Harney <chrak@efnet>\n"
		 ,argv[0]);
	  exit(-1);
      }
    args.tcp.seq = 0;
    args.tcp.ack = 0;
    args.tcp.s_port = 7777;
    args.tcp.d_port = 7778;
    args.tcp.urgpoint = 0;
    args.tcp.win = 512;
    args.udp.s_port = 7777;
    args.udp.d_port = 7778;
    args.icmptype = ICMP_ECHO;
    args.tcp.def_flag = 1;
    args.tcp.flags = 0;
    args.rnum = 1;
    memset(&args.data, '\0', sizeof(args.data));
    memset(&args.wpackfile, '\0', sizeof(args.wpackfile));
    memset(packet, '\0', sizeof(packet));
    ip_header->ttl = 60;
    ip_header->id = htons(getpid());
    ip_header->version = IPVERSION;
    ip_header->ihl = 5;
    ip_header->tos = 0;
    ip_header->protocol = IPPROTO_RAW;

    if (!strcmp(argv[1], "-N"))
	curses(&args, ip_header);
    else if (cmdline(argc, argv, &args, ip_header))
	exit(-1);

    ip_header->tot_len = IP_SIZE;

    switch (ip_header->protocol)
      {
      case IPPROTO_UDP:
	  ip_header->tot_len += UDP_SIZE;

	  if (DATA_SIZE)
	    {
		strncpy(packet + ip_header->tot_len, args.data, DATA_SIZE);
		ip_header->tot_len += DATA_SIZE;
	    }
	  add_udphdr(packet, args);
	  break;
      case IPPROTO_TCP:
	  if (args.tcp.def_flag)
	      args.tcp.flags = TH_FIN;
	  ip_header->tot_len += TCP_SIZE;
	  if (DATA_SIZE)
	    {
		strncpy(packet + ip_header->tot_len, args.data, DATA_SIZE);
		ip_header->tot_len += DATA_SIZE;
	    }
	  add_tcphdr(packet, args, ip_header);
	  break;
      case IPPROTO_ICMP:
	  ip_header->tot_len += ICMP_SIZE;
	  if (DATA_SIZE)
	    {
		strncpy(packet + ip_header->tot_len, args.data, DATA_SIZE);
		ip_header->tot_len += DATA_SIZE;
	    }
	  add_icmphdr(packet, args);
	  break;
      }



    memcpy(packet, ip_header, sizeof(struct iphdr));
    ip_header = (struct iphdr *) packet;
    ip_header->check = in_cksum((unsigned short *) packet, sizeof(struct iphdr));

    sendpckt(packet, ip_header, args.rnum);
    if (strlen(args.wpackfile))
      {
	  FILE *f;
	  f = fopen(args.wpackfile, "a");
	  fwrite(packet, 1, ip_header->tot_len, f);
	  fwrite("\n\n\n", 1, 3, f);
	  fclose(f);
      }
}
