#	decode::sumary <packet> ?level? -> string

namespace eval decode {
}


#=======================================================================================
#
#		Build a summary for the packet
#
#=======================================================================================

proc decode::summary {p {level 0}} {
variable summary
variable data

	# reset summary
	set summary ""
	# ask the mappers to contribute
	foreach m [$p mappers] {
		catch {summary:$m $p $m $level} msg
	}
	set summary [string trim $summary ", "]
	# return the string
	return $summary
}

#---------------------------------------------------------------------------------------

proc decode::summary:ethernet {p m level} {
variable summary

	if {$level >= 2} {
		append summary "[$p $m configure -src] > [$p $m configure -dest], "
	}
}

#---------------------------------------------------------------------------------------

proc decode::summary:ip {p m level} {
variable summary
variable data

	append summary "[$p $m configure -src]"
	set data(t:ipsrc) [string length $summary]
	append summary " > [$p $m configure -dest]"
	set data(t:ipdest) [string length $summary]
	append summary ", "
	
	if {$level >= 1} {
		append summary "l=[$p $m configure -length], "

		set flags [$p $m configure -flags]
		if {[string match "*+df*" $flags]} {append summary "DF, "}
		if {[string match "*+mf*" $flags]} {append summary "MF, "}
	}
}

#---------------------------------------------------------------------------------------

proc decode::summary:icmp {p m level} {
variable summary
variable data

	append summary "[$p $m configure -code], "
}

#---------------------------------------------------------------------------------------

proc decode::summary:tcp {p m level} {
variable summary
variable data

	set tmp [string range $summary 0 [expr $data(t:ipsrc)-1]]
	append tmp ":[$p $m configure -src]"
	append tmp [string range $summary $data(t:ipsrc) [expr $data(t:ipdest)-1]]
	append tmp ":[$p $m configure -dest]"
	append tmp [string range $summary $data(t:ipdest) end]

	set summary $tmp

	set flags [$p $m configure -flags]
	if {[string match "*+urg*" $flags]} {append summary "U"}
	if {[string match "*+ack*" $flags]} {append summary "A"}
	if {[string match "*+psh*" $flags]} {append summary "P"}
	if {[string match "*+rst*" $flags]} {append summary "R"}
	if {[string match "*+syn*" $flags]} {append summary "S"}
	if {[string match "*+fin*" $flags]} {append summary "F"}

	append summary ", "
}

#---------------------------------------------------------------------------------------

proc decode::summary:udp {p m level} {
variable summary
variable data

	set tmp [string range $summary 0 [expr $data(t:ipsrc)-1]]
	append tmp ":[$p $m configure -src]"
	append tmp [string range $summary $data(t:ipsrc) [expr $data(t:ipdest)-1]]
	append tmp ":[$p $m configure -dest]"
	append tmp [string range $summary $data(t:ipdest) end]

	set summary $tmp
}
