#-------------------------------------------------------------------------------------------------
#   ARP (Address Resolution Protocol) & RARP (Reverse ARP)
#-------------------------------------------------------------------------------------------------

protocol arp = {
    spec = "RFC 826"
    size = '8+2*(%data(4,1)+%data(5,1))'

    field -typehardware @ (0, 2) = {
		# from /usr/src/linux-2.0.33/include/linux/if_arp.h
        type = sparelist {
                   0 "netrom" "NET/ROM pseudo"
                   1 "ether" "Ethernet"
                   2 "eether" "Experimental Ethernet"
                   3 "ax25" "AX.25 Level 2"
                   4 "pronet" "PROnet token ring"
                   5 "chaos" "Chaosnet"
                   6 "etherTR" "IEEE 802.2 Ethernet/TR/TB"
                   7 "arcnet" "ARCnet"
                   8 "atalk" "APPLEtalk"
                   15 "frame" "Frame Relay DLCI"
                   23 "strip" "Metricom STRIP (new IANA id)"
                   256 "slip" "SLIP"
                   257 "cslip" "CSLIP"
                   258 "slip6" "SLIP 6"
                   259 "cslip6" "CSLIP 6"
                   260 "rsrvd" "rsrvd"
                   264 "adapt" "adapt"
                   270 "rose" "rose"
                   512 "ppp" "ppp"
                   768 "tunnel" "tunnel"
                   769 "tunnel6" "tunnel6"
                   770 "frad" "frad"
                   771 "skip" "skip"
                   772 "loopback" "loopback"
                   773 "localtalk" "localtalk"
                   774 "fddi" "fddi"
               }
        help = "hardware address space"
		default = 1
    }

    field -typeprotocol @ (2, 2) = {
        type = sparelist {
                   0x0800 "ip" "Internet IP (IPv4)"
               }
        help = "protocol address space"
		default = 0x0800
    }

    field -sizehardware @ (4, 1) = {
        type = integer
        help = "byte length of each hardware address"
		default = 6
    }

    field -sizeprotocol @ (5, 1) = {
        type = integer
        help = "byte length of each protocol address"
		default = 4
    }

    field -op @ (6, 2) = {
        type = list {
                   1 "arp-req" "ARP request"
                   2 "arp-rpl" "ARP reply"
                   3 "rarp-req" "RARP request"
                   4 "rarp-rpl" "RARP reply"
               }
        help = "opcode"
		default = 1
    }

    field -src_ether @ (8, 6) = {
        type = address_ethernet
        help = "ethernet source address"
		default = '%address_ethernet'
		read-only
    }

    field -src_ip @ (14, 4) = {
        type = address_ip
        help = "IP source address"
		default = '%address_ip'
		read-only
    }

    field -dest_ether @ (18, 6) = {
        type = address_ethernet
        help = "ethernet destination address"
		default = '0:0:0:0:0:0'
    }

    field -dest_ip @ (24, 4) = {
        type = address_ip
        help = "IP destination address"
		default = '127.0.0.1'
    }
}