/*
** pat_subnet.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:47:21 1999 
** Last update Thu Oct 28 20:21:00 1999 
*/
#ifndef TYP_SUBNET_H
#define TYP_SUBNET_H	1

#include "pat.h"

/* PSEUDO TYPE FOR MISC USAGES */

typedef struct		s_subnet
{
  struct in_addr	addr;
  struct in_addr	mask;
  struct in_addr	cable;	
  struct in_addr	broadcast;
} t_subnet;

#define SUBNET_ADDR		0
#define SUBNET_CABLE		1
#define SUBNET_BROADCAST	2

#define SUBNET_STYLE_PREFIX	0
#define SUBNET_STYLE_NETMASK	1

typedef t_status	(*t_subnet_walk_proc) P((struct in_addr *ip_addr,
						 int flag,
						 VOID_PTR data));

extern t_pat		subnet_pat;

/* PROTO pat_subnet.c */
/* pat_subnet.c */
int in_class_default_nshift P((struct in_addr *addr));
t_status subnet_from_str P((char *str, t_subnet *subnet));
int prefix_from_netmask P((struct in_addr *netmask, t_status *status));
t_status subnet_to_str P((t_subnet *subnet, char *str, int max_len, int style));
t_boolean is_subnet_member P((struct in_addr *inaddr, t_subnet *subnet));
t_status subnet_walk P((t_subnet *subnet, t_subnet_walk_proc proc, void *data));
t_status vec_prefixes_from_vec_str P((t_vec *vec_pref, t_vec *vec_str));
void subnet_show P((t_subnet *subnet));
t_status subnet_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status subnet_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status subnet_pat_insert P((void *data, char *buf, int len, char *value));
#endif
