/*
** pat_icmp.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:49:24 1999 
** Last update Thu Oct 28 20:21:24 1999 
*/
#ifndef PAT_ICMP_H
#define PAT_ICMP_H	1

#include "pat.h"
#include "pat_ip.h"

typedef struct				s_icmp
{
  t_u8					type;
  t_u8					code;
  t_u16					cksum;
} t_icmp;

#define ICMP_HLEN			4

#define PAT_ICMP_CHECK(icmppar,bufpar,lenpar) \
	if ((lenpar) < ICMP_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(icmppar) = (t_icmp *)(bufpar);

#define ICMP_ECHO_REPLY			0
#define ICMP_UNREACHABLE		3
#define ICMP_SOURCE_QUENCH		4
#define ICMP_REDIRECT			5
#define ICMP_ECHO_REQUEST		8
#define ICMP_ROUTER_ADVERTISEMENT	9
#define ICMP_TIME_EXCEED		11
#define ICMP_TS_REQUEST			13
#define ICMP_TS_REPLY			14
#define ICMP_MASK_REQUEST		17
#define ICMP_MASK_REPLY			18

extern t_assoc				icmptype_assocs[];

extern t_pat				icmpmbz_pat;
extern t_pat				icmpredirect_pat;
extern t_pat				icmpmask_pat;
extern t_pat				icmpts_pat;
extern t_pat				icmp_pat;

/* PROTO pat_icmp.c */
/* pat_icmp.c */
void icmp_compute_sum P((t_ip *ip, t_icmp *icmp));
void icmp_set_proto P((t_ip *ip));
void icmp_set_type P((t_icmp *icmp, int type));
int icmp_get_type P((t_icmp *icmp));
void icmp_set_code P((t_icmp *icmp, int code));
int icmp_get_code P((t_icmp *icmp));
void icmp_set_cksum P((t_icmp *icmp, int sum));
int icmp_get_cksum P((t_icmp *icmp));
t_status icmpmbz_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status icmpmbz_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status icmpmbz_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status icmpmbz_pat_get_fields P((void *data, t_vec *vec_str));
t_status icmpmbz_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status icmpmbz_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status icmpmbz_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status icmpmbz_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status icmpredirect_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status icmpredirect_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status icmpredirect_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status icmpredirect_pat_get_fields P((void *data, t_vec *vec_str));
t_status icmpredirect_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status icmpredirect_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status icmpredirect_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status icmpredirect_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status icmpmask_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status icmpmask_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status icmpmask_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status icmpmask_pat_get_fields P((void *data, t_vec *vec_str));
t_status icmpmask_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status icmpmask_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status icmpmask_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status icmpmask_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status icmpts_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status icmpts_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status icmpts_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status icmpts_pat_get_fields P((void *data, t_vec *vec_str));
t_status icmpts_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status icmpts_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status icmpts_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status icmpts_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status icmp_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status icmp_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status icmp_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status icmp_pat_get_fields P((void *data, t_vec *vec_str));
t_status icmp_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status icmp_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status icmp_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status icmp_pat_sum P((void *data, char *buf, int len, char *up_buf, int up_len));
t_status icmp_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
