/*
** pat_dns.h for  in 
** 
** Made by 
** Login   <vianney@epita.fr>
** 
** Started on  Wed Sep  1 06:49:45 1999 
** Last update Thu Oct 28 20:21:28 1999 
*/
#ifndef PAT_DNS_H
#define PAT_DNS_H	1

#include "pat.h"

typedef struct		s_dns
{
  t_u16			id;
  t_u16			flags;
  t_u16			nquestions;
  t_u16			nanswers;
  t_u16			nauths;
  t_u16			nadds;
} t_dns;

#define DNS_HLEN	12

#define DNS_PORT	53

#define PAT_DNS_CHECK(dnspar,bufpar,lenpar) \
	if ((lenpar) < DNS_HLEN)\
		return (ERR_PAT_TRUNC_PAT);\
	(dnspar) = (t_dns *)(bufpar);

extern int		dns_nquestions_chan;

extern t_pat		dnsrttl_pat;
extern t_pat		dnsrdata_pat;
extern t_pat		dnsqtype_pat;
extern t_pat		dnsqname_pat;
extern t_pat		dns_pat;

/* PROTO pat_dns.c */
/* pat_dns.c */
t_status dnsrttl_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dnsrttl_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dnsrttl_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dnsrttl_pat_get_fields P((void *data, t_vec *vec_str));
t_status dnsrttl_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dnsrttl_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dnsrttl_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dnsrttl_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dnsrdata_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dnsrdata_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dnsrdata_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dnsrdata_pat_get_fields P((void *data, t_vec *vec_str));
t_status dnsrdata_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dnsrdata_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dnsrdata_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dnsqtype_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dnsqtype_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dnsqtype_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dnsqtype_pat_get_fields P((void *data, t_vec *vec_str));
t_status dnsqtype_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dnsqtype_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dnsqtype_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dnsqtype_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dnsqname_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dnsqname_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dnsqname_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dnsqname_pat_get_fields P((void *data, t_vec *vec_str));
t_status dnsqname_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dnsqname_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dnsqname_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dnsqname_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
t_status dnsqname_pat_extract P((void *data, char *buf, int len, char *str, int max_len));
t_status dnsqname_pat_insert P((void *data, char *buf, int len, char *value));
t_status dns_pat_name P((void *data, t_id *optional_id, char *str, int max_len));
t_status dns_pat_get_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *str, int max_len));
t_status dns_pat_set_field P((void *data, t_id *optional_id, char *buf, int len, char *field, char *value));
t_status dns_pat_get_fields P((void *data, t_vec *vec_str));
t_status dns_pat_get_field_pat P((void *data, t_id *optional_id, char *buf, int len, char *field, t_pat **pat_return, void **data_return));
t_status dns_pat_get_tmpl P((void *data, t_id *id, char *buf, int len, char *str, int max_len));
t_status dns_pat_off P((void *data, char *buf, int len, t_off *off_return));
t_status dns_pat_sub P((void *data, t_id *optional_id, char *buf, int len, t_pat **pat_return));
#endif
