/*
** mg_hash.h for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 12:06:18 1999 vianney rancurel
** Last update Thu Oct 28 20:17:51 1999 
*/
#ifndef MG_HASH_H
#define MG_HASH_H	1

#include "mg.h"

#define HASH_BASE		1021		/* prev_prime_before(1024) */
#define HASH_SMALL_BASE		13
#define HASH_TINY_BASE		3
#define HASH_ONE_BASE		1

typedef unsigned long		t_hash_code;

typedef struct			s_hash_elt
{
  VOID_PTR			key;
  VOID_PTR			value;
} t_hash_elt;

typedef int			(*t_hash_cmp_proc) P((VOID_PTR key1,
						      VOID_PTR key2));
typedef VOID_FUNC		(*t_hash_destroy_proc) P((t_hash_elt *he,
							  VOID_PTR data));

/* PROTO mg_hash.c */
/* mg_hash.c */
t_vec *hash_new P((int base, int list_base, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void hash_destroy P((t_vec *ht, t_hash_destroy_proc destroy_proc, void *data));
void hash_delete P((t_vec *ht, t_hash_destroy_proc destroy_proc, void *data));
t_status hash_add P((t_vec *ht, t_hash_code hcode, void *key, void *value));
t_hash_elt *hash_get P((t_vec *ht, t_hash_code hcode, t_hash_cmp_proc cmp_proc, void *key));
t_status hash_rm P((t_vec *ht, t_hash_code hcode, t_hash_cmp_proc cmp_proc, void *key, t_hash_destroy_proc destroy_proc, void *data));
void hash_show_repartition P((t_vec *ht));
#endif
