/*
** XmgPulldown.c for  in 
** 
** Made by vianney rancurel
** Login   <vianney@epita.fr>
** 
** Started on  Wed Aug 25 14:14:08 1999 vianney rancurel
** Last update Thu Oct 28 20:22:21 1999 
*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include "SmeBSBM.h"
#include "XmgMacro.h"
#include "XmgPulldown.h"

VOID_FUNC			XmgPulldownMenuCallback(w,pulldown,cbs)
Widget				w;
Widget				pulldown;
XtPointer			cbs;
{
  char				*label;

  XtVaGetValues(w,
		XtNlabel,	&label,
		NULL);
  XtVaSetValues(pulldown,
                XtNlabel,	label,
                NULL);
}

/* creates a pulldown menu from a vector of strings */
Widget				XmgCreatePulldownFromVecStr(parent,
							    vec_str,
							    proc)
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;

  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (label,menuButtonWidgetClass,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
			{
			  INTERFACE(GETPARENT,
				    CHILDSHELL("menu",simpleMenuWidgetClass,
					       INSERTCODE(
							  VEC_FOR(vec_str,char *str)
							  {
							    INTERFACE(GETPARENT,
								      CHILD("smeBSB",smeBSBObjectClass,
									    XtNlabel,	str,
									    CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
									    END),
								      ENDINTERFACE);
							  }
							    VEC_ENDFOR;
							  ),
					       END),
				    ENDINTERFACE);
			}
			),
	     END),
            ENDINTERFACE);
  return (pulldown);
}

/* creates a complex (subdivised) pulldown menu from a vector of strings */
Widget				XmgCreateComplexPulldownFromVecStr(name,
								   parent,
								   vec_str,
								   proc)
char				*name;
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;
  Widget			menu;
  int				submenu_id;

  submenu_id = 0;
  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (name,menuButtonWidgetClass,
	     XtNlabel,	label,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
			{
			  INTERFACE(pulldown,
				    GETCHILDSHELL(menu)
				    ("menu",simpleMenuWidgetClass,
				     XtNtranslations,
				     XtParseTranslationTable(
"<EnterWindow>:     XmgPopdownAllMenusAfterMe() highlight()  \n\
<LeaveWindow>:     unhighlight()           \n\
<BtnMotion>:       highlight()             \n\
<BtnUp>:           XmgPopdownAllMenus() notify() unhighlight()\n"),
				     INSERTCODE(
						VEC_FOR(vec_str,char *str)
						{
						  Dimension	height;
						  
						  INTERFACE(menu,
							    CHILD("smeBSB",smeBSBObjectClass,
								  XtNlabel,	str,
								  CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
								  END),
							    ENDINTERFACE);
						  XtRealizeWidget(menu);
						  XtVaGetValues(menu,
								XtNheight,	&height,
								NULL);
						  if ((height + 100) > DisplayHeight(XtDisplay(menu),
										     DefaultScreen(XtDisplay(menu))) &&
						      VEC_IDX != (VEC_COUNT(vec_str) - 1))
						    {
						      char	submenu_name[STR_BUFSIZ];
						      t_status	status;
						      
						      submenu_name[0] = 0;
						      status = ulong_to_str((unsigned long)submenu_id++,
									    10,
									    submenu_name,
									    sizeof (submenu_name));
						      assert(status == 0);
						      INTERFACE(menu,
								CHILD("more...",smeBSBMObjectClass,
								      XtNmenuName,submenu_name,
								      END),
								ENDINTERFACE);
						      INTERFACE(pulldown,
								GETCHILDSHELL(menu)
								(submenu_name,simpleMenuWidgetClass,
								 XtNtranslations,
								 XtParseTranslationTable(
"<EnterWindow>:     XmgPopdownAllMenusAfterMe() highlight()  \n\
<LeaveWindow>:     unhighlight()           \n\
<BtnMotion>:       highlight()             \n\
<BtnUp>:           notify() unhighlight()\n"),
								 END),
								ENDINTERFACE);
						    }
						}
						  VEC_ENDFOR;
						),
				     END),
				    ENDINTERFACE);
			}
			),
	     END),
            ENDINTERFACE);
  return (pulldown);
}

/* create a pulldown menu from a vector of strings (used by XmgFancyWidget). 
   This is used by XmgFancyWidget to fix background color and font */
Widget				XmgFancyCreatePulldownFromVecStr(parent,
								 vec_str,
								 proc,
								 font,
								 bgcolor)
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
XFontStruct			*font;
Pixel				bgcolor;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;

  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (label,menuButtonWidgetClass,
	     XtNmappedWhenManaged,	False,
	     XtNfont,			font,
	     XtNbackground,		bgcolor,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
                        INTERFACE(GETPARENT,
                                  CHILDSHELL("menu",simpleMenuWidgetClass,
					     XtNfont,		font,
					     XtNbackground,	bgcolor,
                                             INSERTCODE(
							VEC_FOR(vec_str,char *str)
							{
							  INTERFACE(GETPARENT,
								    CHILD("smeBSB",smeBSBObjectClass,
									  XtNlabel,		str,
									  XtNfont,		font,
									  XtNbackground,	bgcolor,
									  CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
									  END),
                                                                    ENDINTERFACE);
                                                        }
                                                        VEC_ENDFOR;
                                                        ),
                                             END),
                                  ENDINTERFACE);
                        ),
             END),
            ENDINTERFACE);
  return (pulldown);
}
