/* 
 *  mpac v1.01 12-Aug-1999 13:51
 *  
 *  mpac
 *  tool for creating Ethernet-TCP/IP packets with payload
 *
 *  Written by Byron Sonne <blsonne@home.com>
 *
 *  Inspiration/some code ripped from Libnet (www.packetfactory.net) examples,
 *  Copyright (c) 1998, 1999 Mike D. Schiffman <mike@infonexus.com>
 *  route|daemon9 <route@infonexus.com> 
 *
 */

#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <libnet.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

    char eth_file[FILENAME_MAX] = "";
    char ip_file[FILENAME_MAX] = "";
    char tcp_file[FILENAME_MAX] = "";
    char payload_file[FILENAME_MAX] = "";
    char *payload_location;

    int c = 0;
    int i;
    int payload_filesize = 0;

    u_short t_src_port;		/* TCP source port */
    u_short t_des_port;		/* TCP dest port */
    u_short t_win;		/* TCP window size */
    u_short t_urgent;		/* TCP urgent data pointer */
    u_short i_id;		/* IP id */
    u_short i_frag;		/* IP frag */

    u_long t_ack;		/* TCP ack number */
    u_long t_seq;		/* TCP sequence number */
    u_long i_des_addr;		/* IP dest addr */
    u_long i_src_addr;		/* IP source addr */

    u_char i_ttos[90];		/* IP TOS string */
    u_char t_control[65];	/* TCP control string */
    u_char eth_saddr[6];	/* NULL Ethernet saddr */
    u_char eth_daddr[6]; 	/* NULL Ethernet daddr */
    u_char *buf;
    u_char errbuf[256];
    u_char *device = NULL;
    u_char i_ttos_val = 0;	/* final or'd value for ip tos */
    u_char t_control_val = 0;	/* final or'd value for tcp control */
    u_char i_ttl;		/* IP TTL */
    
    struct link_int *l;	

int main(int argc, char **argv)
{
    while ((c = getopt (argc, argv, "p:t:i:e:")) != EOF)
    {
        switch (c)
        {
            case 'p':
                strcpy(payload_file, optarg);
                break;
            case 't':
                strcpy(tcp_file, optarg);
                break;
            case 'i':
                strcpy(ip_file, optarg);
                break;
            case 'e':
                strcpy(eth_file, optarg);
                break;
            default:
                break;
        }
    }

    if (optind != 9)
    {    
        usage();
        exit(0);
    }

    load_payload();
    load_ethernet();
    load_tcp();
    load_ip();

    /* convert tos and control strings... in future revs this won't be */
    /* needed once I've thought of a better file format and made some  */
    /* file load/parse routines that don't suck ass                    */

    convert_toscontrol();

    /* now the part I've been dreading ;) let's start to build the fucker */
    
    buf = malloc(ETH_H + TCP_H + IP_H + payload_filesize);
    if (!buf)
    {
        printf("malloc for packet failed.\n");
	exit(0);
    }

    /* Open the link layer interface */
    
    device = "eth0";

    l = libnet_open_link_interface(device, errbuf);
    if (!l)
    {
        printf("link layer error on %s : %s\n", device, errbuf);
        exit(0);
    }   

    /* do the builds */

    libnet_build_ethernet(eth_daddr, eth_saddr, ETHERTYPE_IP, NULL, 0, buf);

    libnet_build_ip(TCP_H + payload_filesize, i_ttos_val, i_id, i_frag, i_ttl, IPPROTO_TCP, i_src_addr, i_des_addr, NULL, 0, buf + ETH_H);

    libnet_build_tcp(t_src_port, t_des_port, t_seq, t_ack, t_control_val, t_win, t_urgent, payload_location, payload_filesize, buf + IP_H + ETH_H);

    /* do the checksums... I seem to have some issues with getting the */
    /* right checksum written to the TCP packet... At least according  */
    /* MS Netmon 4.00.351                                              */

    libnet_do_checksum(buf + ETH_H, IPPROTO_IP, IP_H);
    libnet_do_checksum(buf + ETH_H, IPPROTO_TCP, TCP_H + payload_filesize);

    /* inject the packet through device */

    libnet_write_link_layer(l, device, buf, ETH_H + TCP_H + IP_H + payload_filesize);

    /* be a good sam and give the buf memory back */

    libnet_destroy_packet(&buf);
}

    /* usage: Print out usage */
usage()
{
    printf("Usage:\n");
    printf("./mpac -p <payload file> -t <TCP file> -i <IP file> -e <Ethernet file>\n");
}

    /* load_payload: load the payload into memory */
load_payload()
{
    FILE *infile;
    struct stat statbuf;
    int i = 0;
    int c = 0;

    /* get the file size so we can figure out how much memory to allocate */
 
    stat(payload_file, &statbuf);
    payload_filesize = statbuf.st_size;

    payload_location = (char *)malloc(payload_filesize * sizeof(char));
    if (payload_location == 0)
    {
        printf("Allocation of memory for payload failed.\n");
        exit(0); 
    }

    /* open the file and read it into memory */

    infile = fopen(payload_file, "r");	/* open the payload file read only */
    
    while((c = getc(infile)) != EOF)
    {
        *(payload_location + i) = c;
        i++;
    }

    fclose(infile);
}

    /* load_ethernet: load ethernet data file into the variables */
load_ethernet()
{
    FILE *infile;

    char s_read[40];
    char d_read[40];

    infile = fopen(eth_file, "r");

    fgets(s_read, 40, infile);
    fgets(d_read, 40, infile);

    sscanf(s_read, "saddr,%x, %x, %x, %x, %x, %x", &eth_saddr[0], &eth_saddr[1], &eth_saddr[2], &eth_saddr[3], &eth_saddr[4], &eth_saddr[5]);

    sscanf(d_read, "daddr,%x, %x, %x, %x, %x, %x", &eth_daddr[0], &eth_daddr[1], &eth_daddr[2], &eth_daddr[3], &eth_daddr[4], &eth_daddr[5]);

    fclose(infile);
}

    /* load_tcp: load TCP data file into the variables */
load_tcp()
{
    FILE *infile;

    char sport_line[20] = "";
    char dport_line[20] = "";
    char seq_line[20] = "";
    char ack_line[20] = "";
    char control_line[65] = "";
    char win_line[20] = "";
    char urg_line[20] = "";

    infile = fopen(tcp_file, "r");

    fgets(sport_line, 15, infile);
    fgets(dport_line, 15, infile);
    fgets(win_line, 12, infile);
    fgets(urg_line, 12, infile);
    fgets(seq_line, 13, infile);
    fgets(ack_line, 13, infile);
    fgets(control_line, 63, infile);

    /* parse the strings and stuff the values into the variable */

    sscanf(sport_line, "sport,%d", &t_src_port);
    sscanf(dport_line, "dport,%d", &t_des_port);
    sscanf(win_line, "win,%d", &t_win);
    sscanf(urg_line, "urg,%d", &t_urgent);
    sscanf(seq_line, "seq,%ld", &t_seq);
    sscanf(ack_line, "ack,%ld", &t_ack);
    sscanf(control_line, "control,%[^!]", &t_control);

    fclose(infile);
}

    /* load_ip: load IP data file into memory */
load_ip()
{
    FILE *infile;
    
    char id_line[40] = "";
    char frag_line[40] = "";
    char ttl_line[40] = "";
    char saddr_line[40] = "";
    char daddr_line[40] = "";
    char tos_line[90] = "";
    char z_zsaddr[40] = "";
    char z_zdaddr[40] = "";

    infile = fopen(ip_file, "r");

    fgets(id_line, 11, infile);
    fgets(frag_line, 13, infile);
    fgets(ttl_line, 10, infile);
    fgets(saddr_line, 24, infile);
    fgets(daddr_line, 24, infile);
    fgets(tos_line, 78, infile);
    
    sscanf(id_line, "id,%d", &i_id);
    sscanf(frag_line, "frag,%d", &i_frag);
    sscanf(ttl_line, "ttl,%d", &i_ttl);
    sscanf(saddr_line, "saddr,%s", &z_zsaddr);
    sscanf(daddr_line, "daddr,%s", &z_zdaddr);
    sscanf(tos_line, "tos,%[^!]", &i_ttos);

    i_src_addr = libnet_name_resolve(z_zsaddr, 1);
    i_des_addr = libnet_name_resolve(z_zdaddr, 1); 

    fclose(infile);
}

    /* convert_toscontrol:  or flags in strings to make u_chars */
convert_toscontrol()
{
    if(strstr(t_control, "th_urg") != NULL)
        t_control_val = t_control_val | TH_URG;

    if(strstr(t_control, "th_ack") != NULL)
        t_control_val = t_control_val | TH_ACK;

    if(strstr(t_control, "th_psh") != NULL)
        t_control_val = t_control_val | TH_PUSH;

    if(strstr(t_control, "th_rst") != NULL)
        t_control_val = t_control_val | TH_RST;

    if(strstr(t_control, "th_syn") != NULL)
        t_control_val = t_control_val | TH_SYN;

    if(strstr(t_control, "th_fin") != NULL)
        t_control_val = t_control_val | TH_FIN;

    if(strstr(i_ttos, "iptos_lowdelay") != NULL)
        i_ttos_val = i_ttos_val | IPTOS_LOWDELAY;

    if(strstr(i_ttos, "iptos_throughput") != NULL)
        i_ttos_val = i_ttos_val | IPTOS_THROUGHPUT;

    if(strstr(i_ttos, "iptos_reliability") != NULL)
        i_ttos_val = i_ttos_val | IPTOS_RELIABILITY;

    if(strstr(i_ttos, "iptos_mincost") != NULL)
        i_ttos_val = i_ttos_val | IPTOS_MINCOST;
}

/* eof */
