#ifndef __DATADISP_H
#define __DATADISP_H 1

/* File   : datadisp.h                                                      */
/* Purpose: Definitions and include files needed by datadisp.c.             */

#ifdef SunOS
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#endif /* SunOS */

#ifdef BSDI31
#include <netinet/in.h>       /* sockaddr_in */
#include <arpa/nameser.h>     /* MAXDNAME    */
#include <resolv.h>           /* in_addr     */
#include <netinet/in_systm.h> /* n_long      */
#endif /* BSDI31 */

#include <netinet/udp.h>   /* UDP header struct  */
#include <netinet/tcp.h>   /* TCP header struct  */
#include <netinet/ip.h>    /* IP Header struct   */
#include <net/if_arp.h>
#include "maketcp_func.h"  /* full_tcphdr struct */
#include "makeudp_func.h"  /* full_udphdr struct */
#include "ethernet.h"      /* my_ethhdr struct   */

/* Global variables */
int ip_protocol;

/* Function prototypes */
int print_ip_data(struct ip *);
void hwaddrprint(unsigned char *);
void print_arp_data(struct arphdr *);
void print_eth_data(my_ethhdr *);
void print_full_tcp_data(struct full_tcphdr *);
void print_full_udp_data(struct full_udphdr *);
void print_ip(unsigned char *);
void print_tcp_data(struct tcphdr *);
void print_udp_data(struct udphdr *);

#endif  /* __DATADISP_H */
