#include <linux/kernel.h>
#include <linux/tcfs/tcfsapi.h>

extern void init_tcfs_syms(void);
extern int init_tcfs_fs(void);
extern void cleanup_tcfs_fs(void);

int tcfs_debug=0;
unsigned int tcfs_numread=0, tcfs_numwrite=0, tcfs_numofgetheader=0;
unsigned int tcfs_numreadflags=0, tcfs_numreadget=0;
unsigned int tcfs_numputwrite=0, tcfs_numputflags=0, tcfs_numofputheader=0;
unsigned int tcfs_numreadpage=0, tcfs_numwritepage=0;

#ifdef MODULE

int
init_module (void)
{
	int status;

	status=init_tcfs_fs ();

	printk(KERN_WARNING "TCFS 3.0 loaded\n");

	return status;
}

void
cleanup_module (void)
{
	cleanup_tcfs_fs ();

	printk("TCFS 3.0 unloaded\n");
}

#endif
