#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/mm.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/fs.h>
#include <linux/tcfs_fs.h>
#include <linux/ioctl.h>
#include <linux/malloc.h>
#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
/* This is for kernel_thread */
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>

#include <linux/tcfs/cipherinterface.h>
#include <linux/tcfs/tcfs_library.h>
#include <linux/tcfs/hash.h>

#define TCFS_DEBUG

int tcfsusers;

int
tcfs_ioctl(struct inode * inode, struct file * filp, unsigned int cmd,
			unsigned long arg)
{
	struct login lg;
	struct tgroup gl; 
	int uid, gid;
	int err=0;
	void *ks;
	void *gks;
	struct gid_hash_entry * ghtmp;
	struct hash_entry * he;
	struct tcfs_header tcfsheader;
	unsigned int mode=0;
	struct tcfs_fattr fattr;
	char ciphername[TCFS_ENGINE_FIELD_SIZE];
	/*
	char tcfs_version[]={
                        TCFS_VERSION,
                        TCFS_VERSION_MINOR,
                        0,
			CIPHER_DES
                    }; 
	*/

	switch(cmd) {
	case TCFS_IOC_GETFLAGS:
		err=tcfs_get_header (inode, &tcfsheader, NULL);
		if (err<0)
			tcfsheader.flags=0;

		copy_to_user ((unsigned int *)arg,
			&tcfsheader.flags,
			sizeof(unsigned int));

		inode->u.tcfs_i.tcfsheader.flags=tcfsheader.flags;

		return 0;

	case TCFS_IOC_SETFLAGS:
		/* Anidel:
		 * manca la chiamata alla tcfs_setettr
		 * ovvero alla funzione che controlla i permessi (per il
		 * settaggio dei flags, e che effettua la vera e propria
		 * cifratura, decifratura del file
		 * ('o meglj!)
		 * FATTO nella tcfs_modify_header.
		 */
		if (current->uid != inode->i_uid) {
			err=-EACCES;
			return err;
		}

		copy_from_user(&mode,(unsigned int *)arg,sizeof(unsigned int));
		err = tcfs_modify_header (filp, NULL, TCFS_FIELD_FLAGS,
					(void *)&mode, NULL);
		if (err)
			return err;

		inode->u.tcfs_i.tcfsheader.flags=mode;

		return -TCFS_ERROK;

	case TCFS_IOC_GETVERSION:
/*		put_user(*(long *)tcfs_version, (long *)arg);*/
		return 0;
	case TCFS_IOC_SETVERSION: /* for compatibility purpouses */
		return 0;
	case TCFS_IOC_SETCIPHER:
		copy_from_user (ciphername, (char *)arg, TCFS_ENGINE_FIELD_SIZE);

		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;

		tcfs_modify_header (filp, NULL, TCFS_FIELD_ENGINE,
				ciphername, he->ks);

		return 0;

	case TCFS_IOC_LOGIN:
		copy_from_user ((char *)&lg,(char *)arg,sizeof(struct login));

		ks=tcfs_init_key (lg.deskey, lg.ciphername);
		if (ks==NULL) {
			return -ENOMEM;
		}

#ifdef TCFS_DEBUG_KEY
		{
			int i;
			char *pnt;

			printk("TCFS_debug: key is: ");

			pnt=(char *)&ks[0];
	 		for(i=0;i<16;i++,pnt++){	
				printk("%x:",(unsigned int)*pnt);
			}
			printk("\n");	
		
		}
#endif
			
		if (hash_add(lg.uid,lg.deskey,ks)==NULL) {
			kfree(ks);
		}

		tcfsusers++;
		return 0;

	case TCFS_IOC_LOGOUT:
		copy_from_user(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem_count(uid);
		if (tcfsusers)
			tcfsusers--;

		return 0;

	case TCFS_IOC_FULLOUT:
		copy_from_user(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem_all(uid);
		return 0;

	case TCFS_IOC_SETFIX:
		if ((he=hash_lookup(current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;

	case TCFS_IOC_GETFIX:
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned char *)arg);
		return 0;

	case TCFS_IOC_GETCOUNT:
		he=hash_lookup(current->uid);
		if (he==NULL) {
			return -EINVAL;
			put_user(0,(unsigned int *)arg);
		}
		put_user(he->count,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_DELFIX:
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		hash_rem_permanent(current->uid);
		return 0;

	case TCFS_IOC_GLOGIN:
#ifdef TCFS_DEBUG
		printk ("TCFS_debug: in TCFS_IOC_GLOGIN\n");
#endif
		copy_from_user(&gl,(struct tgroup *)arg,sizeof(gl));
#ifdef TCFS_DEBUG_KEY
		{
			int i;
			printk ("TCFS_debug: key got via ioctl is: ");
			for (i=0;i<(KEYSIZE+KEYSIZE/8);i++)
				printk ("%u:", gl.deskey[i]);
			printk ("\n");
		}
#endif

		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			ghtmp=gid_hash_add(gl.gid);
		if (gid_uid_add(gl.gid,gl.uid,gl.deskey)==NULL)
			return 0;
		if (ghtmp->ins<gl.soglia)
			return 0; 
                if (ghtmp->ins>gl.soglia) {
#ifdef TCFS_DEBUG
			printk("TCFS_debug: Key already present.\n");
#endif
			return 0;
		}
#ifdef TCFS_DEBUG
		printk ("TCFS_debug: threshold limit reached...interpolating..\n");
#endif

		memset(ghtmp->gidkey,'\0',KEYSIZE);
		interp(ghtmp->key,ghtmp->ins,ghtmp->gidkey);

/* ???
		if (ghtmp->ks==NULL) {
			gks=(des_key_schedule *)kmalloc(2*sizeof(des_key_schedule),GFP_KERNEL);  
			if (gks==NULL) {
				return -ENOMEM;
			}
			ghtmp->ks=gks;
		}
*/

		ghtmp->ks=tcfs_init_key (ghtmp->gidkey, NULL);

#ifdef TCFS_DEBUG
		printk ("TCFS_debug: exiting TCFS_IOC_GLOGIN\n");
#endif
		return 0;

	case TCFS_IOC_GLOGOUT:
		copy_from_user(&gl,(struct tgroup *)arg,sizeof(gl));
		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			return 0;
		gid_uid_rem_count(gl.gid,gl.uid);
		if (ghtmp->ins==0) {
			gid_hash_rem(gl.gid);
			return 0;
		}

		/* If we go below the threshold, the key gets removed */
		if (ghtmp->ins<gl.soglia) {
			gks=ghtmp->ks;
			ghtmp->ks=NULL;
			kfree(gks);
			memset(ghtmp->gidkey,'\0',KEYSIZE);
		}
		return 0;

	case TCFS_IOC_GFULLOUT:
		copy_from_user(&gid,(unsigned int *)arg,sizeof(gid));
		gid_uid_rem_all(gid,current->uid);
		return 0;
	case TCFS_IOC_GSETFIX:
		copy_from_user(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;

	case TCFS_IOC_GGETFIX:
		copy_from_user(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_GGETCOUNT:
		copy_from_user(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->count,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_GDELFIX:
		copy_from_user(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		gid_uid_rem_permanent(gid,current->uid);
		return 0;
	default:
			return -ENOTTY;
	}
}
