/*

  silcpayload.h

  Author: Pekka Riikonen <priikone@poseidon.pspt.fi>

  Copyright (C) 2000 Pekka Riikonen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

*/

#ifndef SILCPAYLOAD_H
#define SILCPAYLOAD_H

/* Forward declarations */
typedef struct SilcIDPayloadStruct *SilcIDPayload;
typedef struct SilcArgumentPayloadStruct *SilcArgumentPayload;

/* Prototypes */
SilcIDPayload silc_id_payload_parse(SilcBuffer buffer);
SilcIDPayload silc_id_payload_parse_data(unsigned char *data, 
					 uint32 len);
void *silc_id_payload_parse_id(unsigned char *data, uint32 len);
SilcBuffer silc_id_payload_encode(void *id, SilcIdType type);
void silc_id_payload_free(SilcIDPayload payload);
SilcIdType silc_id_payload_get_type(SilcIDPayload payload);
void *silc_id_payload_get_id(SilcIDPayload payload);
unsigned char *silc_id_payload_get_data(SilcIDPayload payload);
uint32 silc_id_payload_get_len(SilcIDPayload payload);
SilcArgumentPayload silc_argument_payload_parse(SilcBuffer buffer,
						uint32 argc);
SilcBuffer silc_argument_payload_encode(uint32 argc,
					unsigned char **argv,
					uint32 *argv_lens,
					uint32 *argv_types);
SilcBuffer silc_argument_payload_encode_payload(SilcArgumentPayload payload);
void silc_argument_payload_free(SilcArgumentPayload payload);
uint32 silc_argument_get_arg_num(SilcArgumentPayload payload);
unsigned char *silc_argument_get_first_arg(SilcArgumentPayload payload,
					   uint32 *ret_len);
unsigned char *silc_argument_get_next_arg(SilcArgumentPayload payload,
					  uint32 *ret_len);
unsigned char *silc_argument_get_arg_type(SilcArgumentPayload payload,
					  uint32 type,
					  uint32 *ret_len);

#endif
