/*
 *  linux/include/linux/tcfs_ioctl.h
 *
 *  TCFS ioctls
 */

#ifndef _LINUX_TCFS_IOCTL_H
#define _LINUX_TCFS_IOCTL_H

/* TCFS ioctl */
#define TCFS_IOC_GETFLAGS       _IOR('f', 1, long)
#define TCFS_IOC_SETFLAGS       _IOW('f', 2, long)
#define TCFS_IOC_LOGIN          _IOW('l', 1, struct login)
#define TCFS_IOC_LOGOUT         _IOW('l', 2, unsigned int)
#define TCFS_IOC_SETFIX         _IO('l', 3)
#define TCFS_IOC_DELFIX         _IO('l', 4)
#define TCFS_IOC_GETFIX         _IOR('l', 5, unsigned char)
#define TCFS_IOC_GETCOUNT       _IOR('l', 6, unsigned int)
#define TCFS_IOC_FULLOUT        _IOW('l', 7, unsigned int)

#define TCFS_IOC_GLOGIN         _IOW('l', 20, struct tgroup)
#define TCFS_IOC_GLOGOUT        _IOW('l', 21, struct tgroup)
#define TCFS_IOC_GSETFIX        _IOW('l', 22, unsigned int)
#define TCFS_IOC_GDELFIX        _IOW('l', 23, unsigned int)
#define TCFS_IOC_GGETFIX        _IOWR('l', 24, unsigned int)
#define TCFS_IOC_GGETCOUNT	_IOWR('l', 25, unsigned int)
#define TCFS_IOC_GFULLOUT       _IOW('l', 26, unsigned int)

#define TCFS_IOC_SETCIPHER      _IOW('l', 27, char *)

#define TCFS_IOC_GETVERSION     _IOR('v', 1, long)
#define TCFS_IOC_SETVERSION     _IOW('v', 2, long)

#endif
