#ifndef _TCFS_FS_SB
#define _TCFS_FS_SB

#include <linux/tcfs.h>
#include <linux/in.h>

/*
 * TCFS client parameters stored in the superblock.
 */
struct tcfs_server {
	struct rpc_clnt *	client;		/* RPC client handle */
	int			flags;		/* various flags */
	int			rsize;		/* read size */
	int			wsize;		/* write size */
	unsigned int		bsize;		/* server block size */
	unsigned int		acregmin;	/* attr cache timeouts */
	unsigned int		acregmax;
	unsigned int		acdirmin;
	unsigned int		acdirmax;
	char *			hostname;	/* remote hostname */
};

/*
 * tcfs super-block data in memory
 */
struct tcfs_sb_info {
	struct tcfs_server	s_server;
	struct tcfs_fh		s_root;
};

#endif
