#ifndef _TCFS_FS_I
#define _TCFS_FS_I

#include <linux/tcfs.h>
#include <linux/pipe_fs_i.h>
#include <asm/semaphore.h>

#if 0 /* old tcfs_inode_info */
/*
 * tcfs fs inode data in memory
 */
struct tcfs_inode_info {
	struct pipe_inode_info pipeinfo;
	struct nfs_fh fhandle;
	/*
	 * read_cache_jiffies is when we started read-caching this inode,
	 * and read_cache_mtime is the mtime of the inode at that time.
	 *
	 * We need to invalidate the cache for this inode if
	 *
	 *	jiffies - read_cache_jiffies > 30*HZ
	 * AND
	 *	mtime != read_cache_mtime
	 */
	unsigned long read_cache_jiffies;
	unsigned long read_cache_mtime;
	/*
	 * This is to support the clandestine rename on unlink.
	 * Instead of the directory inode, we might as well keep its
	 * TCFS FH, but that requires a kmalloc.
	 */
	struct inode *silly_rename_dir;
	/*
	 * attrtimeo defines for how long the cached attributes are valid
	 */
	unsigned int readcount;
	unsigned long attrtimeo;
	char pathname[TCFS_MAXPATHLEN+1];
	char ciphername[TCFS_ENGINE_FIELD_SIZE];
	union {
		unsigned int cflag; 
/*
	---- ---s ssSG
	1234 1234 1234 1234 1234 1234 1234 1234

	Legenda:
		s	spurebits (3 bits)
		S	securefl (1 bit)
		G	sharedfl (1 bit)
*/
		struct {
			unsigned int ext2fl:7;
			unsigned int spurebits:3;
			unsigned int securefl:1;
			unsigned int sharedfl:1;
			unsigned int unused:20;
/* TCFS 2.2.x old bit field:
			unsigned int ext2:7;
			unsigned int mb:1;
			unsigned int spure:3;
			unsigned int gshar:1;
			unsigned int unknown:20;
*/
		} bf;
	} tcfs_fl;
	struct semaphore mutex;
	struct semaphore wrt;
};
#endif /* 0 */

/* new tcfs_inode_info */
struct tcfs_inode_info {
	/* see nfs_fs_i.h for more info on this five fields */
	struct pipe_inode_info		pipeinfo;
	unsigned long			read_cache_jiffies;
	unsigned long			read_cache_mtime;
	unsigned long			attrtimeo;
	unsigned short			flags;
	struct tcfs_wreq		*writeback;
	/* TCFS related fields */
	struct tcfs_fh			*fhandle;
	struct tcfs_inode_header	tcfsheader;
	unsigned short			cached;
};

#define TCFS_INO_REVALIDATE	0x0001
#define TCFS_IS_SNAPSHOT	0x0010

/*
 * TCFS lock info
 */
struct tcfs_lock_info {
	u32	state;
	u32	flags;
};

#define TCFS_LCK_GRANTED	0x0001

#endif
