#ifndef _TCFS_H_
#define _TCFS_H_

#define TCFS_CIPHERNAME_LEN	16

struct tcfs_cipher_operations {
	void *(*init_key) (char *);
	void (*cleanup_key) (void *);
	void (*encrypt) (char *, int, void *);
	void (*decrypt) (char *, int, void *);
};

struct tcfs_cipher_hook {
	char cipher_name[TCFS_CIPHERNAME_LEN];
	struct tcfs_cipher_operations *cipher_ops;
	struct tcfs_cipher_hook *next;
};

extern struct tcfs_cipher_hook *tcfs_hook_start;
extern void tcfs_register_cipher (char *, struct tcfs_cipher_operations *);
extern void tcfs_unregister_cipher (char *);

#endif /* _TCFS_H_ */
