#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];

/* When a process exists, we shall delete the
   privlage entry. We need to know nothing about
   the process when it will no longer spawn
   processes. 
 */

int
sj_exit (int error)   /* DONE */
{
  int sj_exit_ret;
#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
#endif

#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif

#ifdef DEBUG
  printk ("(StJude) sj_exit: Pid %d Exit.\n", current->pid);
#endif

#ifdef __SMP__
write_lock(&argv_memory_lock);
#endif
  destroy_argv_memory(current->pid);
#ifdef __SMP__
write_unlock(&argv_memory_lock);
#endif

  if (!(current->uid && current->euid && current->suid))
  {
        /* Its ok if we delete a record that doesn't exist here..
           If a suid program spawned and exit() was its first
           syscall it could happen. Thats all good. 
         */
#ifdef __SMP__
    write_lock(&priv_lock);
#endif
        destroy_priv_record(current->pid);
           
        
#ifdef __SMP__
    write_unlock(&priv_lock);
#endif
  }

#ifdef __SMP__
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif

  sj_exit_ret = (*orig_exit) (error);
  return sj_exit_ret;
}

