#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];

/* This is a mite bit hackish way to handle suid programs. See below for more
   discussion. 
 */

void suid_hack(struct task_struct *p)
{
   struct sj_argv_memory *memory;

#ifdef DEBUG
   printk("(StJude) Enterd Suid Hack\n");
#endif
        /* It has some vestages of privlage, lets check
           if its in the hash. 
         */
                /* We do not have a priv record for this suid privlaged.
                   process. This will occur, but only should occur when
                   a suid process is run. The privlage bits in the task
                   structure is set deep inside exec() without a syscall
                   (ie, the exec() call modifies the task_struc). This poses
                   a problem for us, since we do not know that a process
                   has been given privlage. What we will do here is extract
                   the argv's for the command from its memory, and create
                   a privl record after getting the proper restriction index.
                 */


		  memory = get_argv_memory(p->pid);
                  if (memory) {
			    int r_index = 0;
                  
		/* Note, here we will need to get an index based on the parent. */

                           r_index =  get_restriction_index(p->p_pptr->pid,
						memory->argv);

                           create_priv_record(p->pid,r_index);
                    }
                    else  
                      create_priv_record(p->pid,0);
   			return;

}
