#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include <linux/mman.h>
#include "StJude_lkm.h"


/* 
   This responce will execute the program pointed to by sjfilename
   with the command line arguments defined in sjargv (remember argv[0]
   is the filename). 

   This provides the opportunity to redirect the execution to a application
   of our choosing. This application executes in the context of the process
   that has genrated the event. This affords us a great opportunity to
   further analyze the situation from the point-of-view of the potental
   attacker (mabey take a snapshot of the history and filesystem), 
   or initate a responce.

   It is likely to be noted by an astute individual that this also affords
   the opportunity to counter-attack the attacker, using their control
   channel aginst them. This is a distinct possiblity, but something I
   want to personally discourage.

   Additionally, make note that the process spawned with run with the
   privlages the attacker tried to acquire. This means:

            1) Do not execeve anything without first dropping privlages.
 
			Else Endless loop.

            2) Be Very Careful.

                        

   --Tim
 */


extern int sjexecve;
char *sjfilename = "/usr/bin/printf"; 
char *sjargv[] = { "/usr/bin/printf", "Stop Hacking My System\n\n\t\t\t-- The Sysadmin.\n", NULL } ;

/* 
   It is necessary to allocate memory in userspace, in the context
   of process that has generated this even. Thusly, we need to be
   able to allocate and free memory in userspace.... I give you:

 */

void * sj_malloc(unsigned long size)
{
   unsigned long memory;
   unsigned long req_size;

   if (size % 1024)
        req_size = size + ( 1024 - size % 1024 );  
   else
   	req_size = size;

   memory =  do_mmap( NULL, 0, req_size, 
   		PROT_READ|PROT_WRITE, MAP_PRIVATE|MAP_ANONYMOUS,0);

   if ( memory > -4096 )
   	return NULL; /* Error.. Don't care which one. */
   else
        return (void *) memory;
   
}

void sj_free( void * memory, unsigned long size)
{
   unsigned long req_size;

   if (size % 1024)
        req_size = size + ( 1024 - size % 1024 );  
   else
   	req_size = size;

#if ((LINUX_VERSION_CODE > KERNEL_VERSION(2,2,0)) &&\
     LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)) 
   do_munmap((unsigned long) memory,req_size);
#elif ((LINUX_VERSION_CODE > KERNEL_VERSION(2,4,0)) &&\
     LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)) 
   do_munmap(current->mm,(unsigned long) memory,req_size);
#else
#error "Unable to Handle Dev kernel versions, or versions outside the 2.2 and 2.4 serise"
#endif

   return;
}

sj_do_response (char *filename, char **argv, char **envp)
{
 
    char **sjenvp = envp;
    int sj_res,size,argc;
    char *userfilename;
    char **userargs;  

   size = sj_strlen(sjfilename,BUFFSIZE)+1;
   userfilename = sj_malloc(size); 

   if (!userfilename)
	return;
   
   copy_to_user(userfilename,sjfilename,size);

   /* Forgive me father, for I have sinned. */
   argc = ( size = (sj_strlen((char *) sjargv,BUFFSIZE) ) ) / sizeof(void *) ;
 
   userargs = sj_malloc(size + sizeof(void*)); 
   copy_to_user(userargs[argc],sjargv[argc],sizeof(void *));
   for (sj_res = 0;sj_res < argc;sj_res++)
	{
            size = sj_strlen(sjargv[sj_res],BUFFSIZE) + 1;
            userargs[sj_res] = sj_malloc(size);
            copy_to_user(userargs[sj_res],sjargv[sj_res],size);

        } 
    
    __asm__ volatile ("int $0x80":"=a" (sj_res):"0" (sjexecve), 
			"b" ((long) (userfilename)), 
			"c" ((long) (userargs)), 
			"d" ((long) (envp)));
  
}

sj_do_landmine_response (char *filename, char **argv, char **envp)
{
    send_sig(SIGKILL,current,1);
    return 0;
}
