#define MODULE
#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"



extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];

int sjexecve;

int
init_module(void)
{
    struct task_struct *p;
    struct task_struct *inittask;
    int sjlandmine;
    struct sj_argv_memory *memory;
    int             i;

    /*
     * Our memory is not cleared for us. We need to init our hashes so that
     * each hash is like null. 
     */

    for (i = 0; i < SJ_PRIV_HASH; i++)
	sj_priv_hash[i] = NULL;

    for (i = 0; i < SJ_MEMORY_HASH; i++)
	sj_argv_memory_hash[i] = NULL;

    sjexecve = NR_syscalls - 1 - SJ_MINES_FORWARD - (current->pid %5);

#ifndef SILENT
    printk("Loading %s ... ", VERSION);
#endif

    /*
     * Now to "Pardon" all running processes. We are doing this (kludge)
     * because we need some starting point. We could do the hard thing and
     * "figure" out the initial restrictions for our processes.
     * 
     * This is a TODO thing. If we do do this, then we can detect network
     * based root compromises. Wouldn't that be fun?
     * 
     * If we fail here, we abort -- leaving our kernel nice and working.
     * 
     */
#ifdef __SMP__

    /* Initilize our Spinlocks to Unlocked... */
    rwlock_init(&sj_running);
    rwlock_init(&priv_lock);
    rwlock_init(&argv_memory_lock);

    /* Lock the tasklist while we muck with it. */
    read_lock(&tasklist_lock);
#endif

    p = (inittask = &(init_task_union.task))->next_task;
    do {
	char            null_argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE] =
	    NULL_ARGV;
	if (!p)
	    break;		/*
				 * healthy paranoia 
				 */

	memory = create_argv_memory(p->pid, null_argv);
	if (!memory) {
	    printk("<1>(StJude) Unable to Init StJude. Aborting.\n");
	    return 1;
	}

	if (!(p->uid && p->euid && p->suid)) {
	    struct sj_priv *priv;

	    priv = create_priv_record(p->pid, 1);
	    if (!priv) {
		printk("<1> (StJude): Unable to Init StJude. Aborting.\n");
		return 1;
	    }
	}
	p = p->next_task;
    } while (p && p != inittask);
#ifdef __SMP__
    read_unlock(&tasklist_lock);
#endif

    orig_do_execve = sys_call_table[__NR_execve];

    /*
     * Kinda dirty, I know. The sys_call_table[0] is a dummy function, it
     * replaces the old setup syscall. We are looking for an empty slot. This 
     * dummy function fills those slots. 
     *
     * Refrence: Complete Linux Loadable Kernel Modules by Pragmatic/THC.
     */

    while (sjexecve != 0 && sys_call_table[sjexecve] != sys_call_table[0])
	sjexecve--;

    if (sjexecve) {
	sys_call_table[sjexecve] = orig_do_execve;
	sys_call_table[__NR_execve] = (void *) sj_do_execve;

        /* Lay the Mines ... */
        for (sjlandmine = sjexecve - 1; 
          (sjlandmine > sjexecve - SJ_MINES_BACK - 1) &&
            sjlandmine > 0; sjlandmine--)
             if ( sys_call_table[sjlandmine] == sys_call_table[0] )
                         sys_call_table[sjlandmine] = (void *) sj_landmine; 
        

        for (sjlandmine = sjexecve + 1; 
          (sjlandmine < sjexecve + SJ_MINES_FORWARD + 1) &&
            sjlandmine < NR_syscalls; sjlandmine++)
             if ( sys_call_table[sjlandmine] == sys_call_table[0] )
                         sys_call_table[sjlandmine] = (void *) sj_landmine; 
    } else {
	printk("<1>Unable to Load StJude.\n");
	return 1;
    }

    (void *) orig_fork = sys_call_table[__NR_fork];
    (void *) orig_vfork = sys_call_table[__NR_vfork];
    (void *) orig_clone = sys_call_table[__NR_clone];
    (void *) orig_exit = sys_call_table[__NR_exit];
    (void *) orig_setuid = sys_call_table[__NR_setuid];
    (void *) orig_setreuid = sys_call_table[__NR_setreuid];
#ifndef LEARNING
#ifndef NOSEAL
    (void *) orig_create_module = sys_call_table[__NR_create_module]; 
    (void *) orig_delete_module = sys_call_table[__NR_delete_module];

    sys_call_table[__NR_create_module] = (void *) sj_create_module;
    sys_call_table[__NR_delete_module] = (void *) sj_delete_module; 
#endif
#endif
    sys_call_table[__NR_setuid] = (void *) sj_setuid;
    sys_call_table[__NR_setreuid] = (void *) sj_setreuid;
    sys_call_table[__NR_fork] = (void *) sj_fork;
    sys_call_table[__NR_vfork] = (void *) sj_vfork;
    sys_call_table[__NR_clone] = (void *) sj_clone;
    sys_call_table[__NR_exit] = (void *) sj_exit;


#ifndef SILENT
    printk("Done. \n");
#endif
    return 0;
}

void
cleanup_module(void)
{
    /*
     * We should free our memory.. 
     */
  
    int             i;
   

    sys_call_table[__NR_setuid] = (void *) orig_setuid;
    sys_call_table[__NR_setreuid] = (void *) orig_setreuid;
    sys_call_table[__NR_fork] = (void *) orig_fork;
    sys_call_table[__NR_vfork] = (void *) orig_vfork;
    sys_call_table[__NR_clone] = (void *) orig_clone;
    sys_call_table[__NR_exit] = (void *) orig_exit;
    sys_call_table[__NR_execve] = (void *) orig_do_execve;
    sys_call_table[sjexecve] = sys_call_table[0];
     /* 
       We should wait untill all calls are finished before ripping the 
       priv and memory out from underneath them, no? 
     */

#ifdef __SMP__
    write_lock(&sj_running);
#endif

    for (i = 0; i < SJ_PRIV_HASH; i++) {
	struct sj_priv *j,
	               *k;

	if (sj_priv_hash[i])
	    for (j = sj_priv_hash[i]; j;) {
		k = j;
		j = j->next;
		kfree(k);
	    }
    }
    
    for (i = 0; i < SJ_MEMORY_HASH; i++) {
	struct sj_argv_memory *j, *k;

	if (sj_argv_memory_hash[i])
	    for (j = sj_argv_memory_hash[i]; j;) {
		k = j;
		j = j->next;
		kfree(k);
	    }
    }

    for (i = NR_syscalls -1; i > 0; i--) 
          if(sys_call_table[i] == sj_landmine)
              sys_call_table[i] = sys_call_table[0];

    /* Kinda a mute point, but we do it for astetics. */
#ifdef __SMP__
    write_unlock(&sj_running);
#endif __SMP__
}
