#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"

SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];


struct sj_argv_memory *
create_argv_memory(pid_t pid, char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE])
{
    struct sj_argv_memory *memory;
    int             i,
                    j;

    memory = kmalloc(sizeof(*memory), GFP_KERNEL);

    if (memory) {
	memory->pid = pid;
	for (i = 0; i < MAX_KEY_ELEMENTS + 1; i++)
	    for (j = 0; j < BUFFSIZE; j++)
		memory->argv[i][j] = argv[i][j];
	memory->next = sj_argv_memory_hash[memory->pid % SJ_MEMORY_HASH];
	sj_argv_memory_hash[memory->pid % SJ_MEMORY_HASH] = memory;
	return memory;
    } else {
	printk("<1>(STJUDE) Unable to allocate memory structure\n");
    }
    return NULL;

}

/*
 * 
 * Get a priv record based on its pid.  (DUH!)
 * 
 */


inline struct sj_argv_memory *
get_argv_memory(pid_t pid)
{
    struct sj_argv_memory *memory;

    memory = sj_argv_memory_hash[pid % SJ_MEMORY_HASH];

    while (memory != NULL) {

	if (memory->pid == pid)
	    break;

	memory = memory->next;

    }

    /* Memory Hack to handle a Vfork Condition. */

    if (memory == NULL) {
	struct sj_argv_memory *parent_memory;

        /* This is not nice, and could be messy... 
           but we were called with a read lock, before
           we do anything we have to release that read lock and get
           a write lock, then re-install the read lock. 

         */


	parent_memory = get_argv_memory(current->p_pptr->pid);
	if (parent_memory) {
	    memory = create_argv_memory(current->pid, parent_memory->argv);
	    if (!memory)
		printk
		    ("(StJude) sj_fork: Something bad happened, I can't remember argv's.\n");
	} else {
	    printk
		("(StJude) suid_hack: Something bad happened. I can't find my parent's (%d) memory.\n",
		 current->p_pptr->pid);
	}

         
    }
    return memory;
}

inline int destroy_argv_memory(pid_t pid)
{
    struct sj_argv_memory *memory;
    struct sj_argv_memory *prev;

    prev = NULL;
    memory = sj_argv_memory_hash[pid % SJ_MEMORY_HASH];

    while (memory != NULL) {

	if (memory->pid == pid)
	    break;

	prev = memory;
	memory = memory->next;

    }


    if (memory != NULL) {
	if (prev != NULL)
	    prev->next = memory->next;
	else
	    sj_argv_memory_hash[pid % SJ_PRIV_HASH] = memory->next;

	kfree(memory);

    } else {
	return 0;
    }				/*
				 * * Tried to delete a record that doesn't
				 * exit 
				 */

    return 1;
}
