/* Useful utility functions common to various modules.
   Copyright (c) 1999, 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <ctype.h>
#include <sys/syslog.h>

#include "vsd.h"
#include "libvsd.h"


const char *get_option (const char *option, const char *cmdline)
{
  char opt[32];
  const char *value;

  value = NULL;

  sprintf (opt, "--%s=", option);
  if (strncmp (cmdline, opt, strlen (opt)) == 0)
    {
      value = cmdline + strlen (opt);
      if (*value == '\0')
	value = NULL;
    }

  return value;
}
