/* Module command interface.
   Copyright (c) 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "module.h"
#include "mod_raw.h"
#include "raw.h"

static struct command_tag clist[] =
{
  {
    CMD_RAW_IO, ADMIN_HOST,
    "Raw protocol access",
    "RAW_IO", 0, "",
    "raw_io", 3, "<host svr> <vs> <infile>"
  },
  {
    0, 0, NULL, NULL, 0, NULL, NULL, 0, NULL
  }
};

/* Return -1 if `cmd' does not exist.
   Return 1 if there is a syntax error.
   Return 0 if everything is cool.  */
int mod_raw_check_cmd (int level, const char *cmd, int argc, char *argv[],
		       struct command_tag **list)
{
  if (cmd == NULL)
    {
      /* Return a pointer to all commands.  */
      *list = clist;
      return 0;
    }

  /* Find command in clist.  */
  *list = module_lookup_command (clist, level, cmd);
  if (*list == NULL)
    return -1;  /* Command does not exist.  */

  /* Check command syntax.  Pretty basic at the moment.  */
#ifdef VSD_LIB
  if (argc < (*list)->vsdadm_args)
    return 1; /* Syntax error.  */
#else
  if (argc < (*list)->vsd_args)
    return 1; /* Syntax error.  */
#endif

  /* Syntax is ok.  */
  return 0;
}

#ifdef VSD_LIB
char *mod_raw_cmd (void *io, int level, const char *cmd,
		   int argc, char **argv)
{
  struct command_tag *list;
  char *status = NULL;

  list = module_lookup_command (clist, level, cmd);
  if (! list)
    return "notexist";

  vsd_set_level (io, list->level);
  switch (list->token)
    {
    case CMD_RAW_IO:
      {
	char *buffer = vsd_read_file (io, argv[2] /* infile */);
	if (buffer)
	  {
	    vsd_send_line (io, "%s\n", buffer);
	    vsd_send_line (io, "EOF", buffer);
	    free (buffer);
	    status = vsd_raw_reply (io);
	  }
	else
	  status = strerror (errno);
      }
      break;
    default:
      return "mod_raw: command not recognised";
      break;
    }

  return status;
}

#else /* ! VSD_LIB */
/* Return 0 if command processed, 1 if not recognised.  */
int mod_raw_cmd (struct connection *vc, int level, const char *command,
		 int argc, char *argv[], const char *data)
{
  int token;
  struct command_tag *tag;

  tag = module_lookup_command (clist, level, command);
  if (tag == NULL)
    return 1;

  token = tag->token;
  switch (token)
    {
    case CMD_RAW_IO:
      raw_io (vc, argc, argv);
      break;
    default:
      return 1;
      break;
    }

  return 0;
}
#endif

module raw_module =
{
  mod_raw_check_cmd,
  mod_raw_cmd
};
