/* Interface to VSD plug-in modules.
   Copyright (c) 1999, 2000 Idaya Ltd.

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include "config.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>

#include "vsd.h"
#include "module.h"

#ifdef VSD_LIB
#include "vsd_lib.h"
#endif

/* See whether `command' exists in `table' defined at level `level'.  */
struct command_tag *module_lookup_command (struct command_tag *table,
					   int level,
					   const char *command)
{
  int x = 0;

#ifdef VSD_LIB
  while (table[x].vsdadm_tag != NULL)
    {
      if ((table[x].level & level))
	if (strcasecmp (command, table[x].vsdadm_tag) == 0)
	  return &table[x];
      x++;
    }
#else
  while (table[x].vsd_tag != NULL)
    {
      if ((table[x].level & level))
	if (strcasecmp (command, table[x].vsd_tag) == 0)
	  return &table[x];
      x++;
    }
#endif

  return NULL;
}

#ifndef VSD_LIB
int module_transaction (struct connection *vc, int level, const char *command,
			int argc, char **argv, const char *data)
{
  module *table;
  int x = 0;

  while ((table = static_modules[x]) != NULL)
    {
      if (table->transaction_function)
	if ((*table->transaction_function) (vc, level, command,
					    argc, argv, data) == 0)
	  return 0; /* Command found and processed.  */
      x++;
    }

  /* Command not found.  */
  return 1;
}
#endif

#ifdef VSD_LIB
char *module_command (void *io, int level, const char *command,
		      int argc, char **argv)
{
  module *table;
  int x = 0;
  char *status;

  while ((table = static_modules[x]) != NULL)
    {
      if (table->command_function)
	{
	  status = (*table->command_function) (io, level, command,
					       argc, argv);
	  if (status && strcmp (status, "notexist") != 0)
	    return status;
	}
      x++;
    }

  return NULL;
}
#endif

/* vsdadm calls this function to display a list of commands implemented
   by each module and a brief description of their function.  */
void module_help (int level, const char *command)
{
  module *table;
  struct command_tag *clist;
  int x = 0;

  while ((table = static_modules[x]) != NULL)
    {
      if (table->check_cmd_function)
	{
	  int y = 0;
	  (*table->check_cmd_function) (level, NULL, 0, NULL, &clist);
	  while (clist[y].vsdadm_tag)
	    {
	      if (command && strcmp (clist[y].vsdadm_tag, command) == 0)
		printf ("  %20s - %s\n", clist[y].vsdadm_tag,
			clist[y].help);
	      else if (! command)
		printf ("  %20s - %s\n", clist[y].vsdadm_tag,
			clist[y].help);
	      
	      y++;
	    }
	}
      x++;
    }
}

/* If the command is not implemented by this module or at the level `level'
   then return `notexist'. If there are an invalid number of arguments
   then return the module syntax. If the syntax is correct then
   return NULL.

   Return 0 if command was handled and correct.
   Return -1 if command exists but contained the wrong number of arguments.
   Return 1 if the command doesn't exist.  */
int module_check_cmd (int level, const char *cmd, int argc, char *argv[],
		      struct command_tag **clist)
{
  module *table;
  int x = 0;
  int status;

  while ((table = static_modules[x]) != 0)
    {
      table = static_modules[x];
      /* Syntax function returns 1 if command doesn't exist.
	 -1 if the arguments are incorrect and 0 on success.  */
      if (table->check_cmd_function)
	{
	  status = (*table->check_cmd_function) (level, cmd, argc, argv, clist);
	  if (status != -1)
	    return status;
	}

      x++;
    }

  /* Command was not found in any modules.  */
  return -1;
}
