/* Restart all processes on a virtual server.
   Copyright (c) 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include "config.h"
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include "libvsd.h"

int main (int argc, char *argv[], char **environ)
{
  int *procs, x, y, killed_something;
  pid_t pid, ppid, pp_pid, ppp_pid;
  const char *new_argv[4];

  {
    struct passwd *p = getpwuid (getuid ());
    if (! p
	|| (strcmp (p->pw_name, "admin") && strcmp (p->pw_name, "root")))
      {
	fprintf (stderr, "%s: permission denied\n", argv[0]);
	return 1;
      }
  }

  /* Get our process id, our parents process id and our parents parents
     process id.  These are the only three process ids that we will not
     kill.  */
  pid = getpid ();
  ppid = getppid ();
  
  /* Ensure we run as uid 0.  */
  setuid (geteuid ());

  pp_pid = vsd_getppid (ppid);
  ppp_pid = vsd_getppid (pp_pid);

#if 0
  printf ("pid = %u, ppid = %u, pppid = %u, ppppid = %u\n",
	  pid, ppid, pp_pid, ppp_pid);
#endif

  /* Get a list of all process ids running on the virtual server.  */
  procs = vsd_enum_procs_vs (NULL);

  printf ("Sending all processes a TERM signal\n");
  x = 0;
  while (procs[x] != -1)
    {
      if (procs[x] != pid && procs[x] != ppid && procs[x] != pp_pid
	  && procs[x] != ppp_pid)
	kill (procs[x], SIGTERM);
      x++;
    }

  /* Pause for a couple of seconds.  This should give the processes
     enough time to shutdown.  */
  sleep (3);

  /* Get an updated list of all processes running on the virtual server.  */
  killed_something = 1;
  for (y = 0; killed_something && y < 4; y++)
    {
      procs = vsd_enum_procs_vs (NULL);
      printf ("Sending all remaining processes a KILL signal\n");
      x = 0;
      killed_something = 0;
      while (procs[x] != -1)
	{
	  if (procs[x] != pid && procs[x] != ppid
	      && procs[x] != pp_pid && procs[x] != ppp_pid)
	    kill (procs[x], SIGKILL), killed_something = 1;
	  x++;
	}
      if (killed_something)
	sleep (2);
    }

  /* Now restart the virtual server processes.  */
  printf ("Starting virtual server processes\n");
  new_argv[0] = "sh";
  new_argv[1] = "-c";
  new_argv[2] = "/etc/rc";
  new_argv[3] = NULL;
  execve ("/bin/sh", (char *const *) new_argv, environ);
  printf ("error: cannot execute /bin/sh\n");
  return 127;
}
