/* List user privileges.
   Copyright (c) 1999, 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include "libvsd.h"

int main (int argc, char *argv[])
{
  char *username = NULL;
  struct vsd_file_line *priv_file;
  char **group_membv, **priv_membv;
  int x, group_membc, priv_membc, min_uid, max_uid;
  struct passwd *pw;

  pw = getpwuid (getuid ());
  if (! pw
      || (strcmp (pw->pw_name, "admin") && strcmp (pw->pw_name, "root")))
    {
      fprintf (stderr, "%s: permission denied\n", argv[0]);
      return 1;
    }

  if (argc != 1 && argc != 2)
    {
      fprintf (stderr, "syntax: listrights [<username>]\n");
      return 1;
    }

  if (argc == 2)
    username = argv[1];

  if (vsd_priv_load (&priv_file, "/"))
    {
      fprintf (stderr, "privileges file not found\n");
      return 1;
    }

  vsd_get_uidgid (NULL, &min_uid, &max_uid, NULL, NULL);

  if (username)
    {
      pw = getpwnam (username);
      if (pw == NULL)
        {
	  fprintf (stderr, "user %s does not exist\n", username);
	  return 1;
	}

      group_membv = vsd_priv_get_group_members ("/", pw->pw_name,
						&group_membc);
      priv_membv = vsd_priv_get_members (priv_file, pw->pw_name,
					 &priv_membc);

      if (! priv_membc && ! group_membc)
	printf ("user %s has no rights\n", pw->pw_name);
      else
	{
	  printf ("user %s has rights: ", pw->pw_name);
	  if (priv_membc)
	    {
	      for (x = 0; x < priv_membc; x++)
		if (x == priv_membc - 1 && ! group_membc)
		  printf ("%s", priv_membv[x]);
		else
		  printf ("%s, ", priv_membv[x]);
		
	      vsd_argv_free (priv_membv, priv_membc);
	    }
	  if (group_membc)
	    {
	      for (x = 0; x < group_membc; x++)
		if (x == group_membc - 1)
		  printf ("%s", group_membv[x]);
		else
		  printf ("%s, ", group_membv[x]);
	      
	      vsd_argv_free (group_membv, group_membc);
	    }
	  printf ("\n");
	}
    }
  else
    {
      printf ("=================+========+=========================================\n");
      printf ("User name        | Uid    | Rights list\n");
      printf ("=================+========+=========================================\n");

      
      setpwent ();
      while ((pw = getpwent ()))
	if (pw->pw_uid >= min_uid && pw->pw_uid <= max_uid)
	  {
	    group_membv = vsd_priv_get_group_members ("/", pw->pw_name,
						      &group_membc);
	    priv_membv = vsd_priv_get_members (priv_file, pw->pw_name,
					       &priv_membc);

	    printf ("%17s|%8d|", pw->pw_name, pw->pw_uid);
	    if (! priv_membc && ! group_membc)
	      printf ("[none set]\n");
	    else
	      {
		if (priv_membc)
		  {
		    for (x = 0; x < priv_membc; x++)
		      if (x == priv_membc - 1 && ! group_membc)
			printf ("%s", priv_membv[x]);
		      else
			printf ("%s, ", priv_membv[x]);
		    
		    vsd_argv_free (priv_membv, priv_membc);
		  }
		if (group_membc)
		  {
		    for (x = 0; x < group_membc; x++)
		      if (x == group_membc - 1)
			printf ("%s", group_membv[x]);
		      else
			printf ("%s, ", group_membv[x]);
		    
		    vsd_argv_free (group_membv, group_membc);
		  }
		printf ("\n");
	      }
	  }
      endpwent ();
      printf ("=================+========+=========================================\n");
    }

  return 0;
}
