/* User group modify command.
   Copyright (c) 1999, 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include "libvsd.h"

int main (int argc, char *argv[])
{
  int c, status, gid = 0;
  char *groupname = NULL;
  char *new_group_name = NULL;
  struct passwd *pw;

  pw = getpwuid (getuid ());
  if (! pw
      || (strcmp (pw->pw_name, "admin") && strcmp (pw->pw_name, "root")))
    {
      fprintf (stderr, "%s: permission denied\n", argv[0]);
      return 1;
    }

  while ((c = getopt (argc, argv, "-g:on:")) != -1)
    switch (c)
      {
      case 'n':
	new_group_name = optarg;
	break;
      case 'g':
	gid = atoi (optarg);
	break;
      case '?':
	fprintf (stderr, "Unknown option `-%c'.\n", optopt);
	return 1;
      default:
        groupname = optarg;
	break;
      }

  if (groupname == NULL)
    {
      fprintf (stderr, "syntax: groupmod [-g gid [-o]] [-n name] group\n");
      return 1;
    }

  status = vsd_groupmod ("/", groupname, gid, new_group_name);
  if (status == 10)
    printf ("%s: couldn't access /etc/group: %s\n", argv[0],
	    strerror (errno));
  else if (status == 9)
    printf ("%s: group `%s' is already in use\n", argv[0], new_group_name);
  else if (status == 6)
    printf ("%s: group `%s' does not exist\n", argv[0], groupname);
  else if (status == 4)
    printf ("%s: gid %d is already in use\n", argv[0], gid);
  else if (status == 2)
    printf ("%s: there is an error somewhere...\n", argv[0]);

  return status;
}
