/* Common code for user quota implementation.
   Copyright (c) 2000 Idaya Ltd.
   Written by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD).

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* The quota file contains one solitary number - the quota limit
   for the virtual server.  */

#include <stdio.h>
#include <stdlib.h>
#include "libvsd.h"

#define VSD_QUOTA "/etc/vsd/quota"

void vsd_quota_set (const char *server_root, int newquota)
{
  struct vsd_file_line *f;

  f = (struct vsd_file_line *) malloc (sizeof (struct vsd_file_line));
  f->line = (char *) malloc (16);
  sprintf (f->line, "%u", newquota);
  f->next = NULL;
  vsd_save_file (f, server_root, VSD_QUOTA);
  vsd_free_file (f);
}

unsigned int vsd_quota_get (const char *server_root)
{
  struct vsd_file_line *f;
  unsigned int quota;

  if (vsd_load_file (&f, server_root, VSD_QUOTA))
    /* File doesn't exist.  Assume server doesn't have any quotas.  */
    quota = 0;
  else
    {
      quota = strtoul (f->line, NULL, 10);
      vsd_free_file (f);
    }

  return quota;
}

