/* Error and debug handling.
   Copyright (c) 2000 Idaya Ltd.
   Written by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <ctype.h>
#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include "libvsd.h"

void vsd_log_error (int severity, const char *fmt, ...)
{
  va_list ap;
  int log;

  va_start (ap, fmt);

  switch (severity)
    {
    case VSD_LOG_PROTOCOL: log = LOG_INFO; break;
    case VSD_LOG_DEBUG: log = LOG_DEBUG; break;
    case VSD_LOG_INFO: log = LOG_INFO; break;
    default: log = LOG_ERR; break;
    }

  vsyslog (log, fmt, ap);
  /*    vfprintf (stderr, fmt, ap); */

  va_end (ap);
}
