/* Input/output handling.
   Copyright (c) 1999 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdlib.h>
#include <string.h>
#include "libvsd.h"

/* For commands that take additional data, use this function to retrieve
   sections of that data a line at a time.  `delim' is the line terminating
   character. `ptr' is a pointer to the start of the string that we 

  `start' and `end' will contain pointers to the start and
   end (delimiter) of the string.  If `*start' is NULL, then it defaults
   to the start of the buffer.

   Return 1 if there are more lines to retrieve, 0 otherwise.  */
char *io_getline (const char delim, const char **ptr)
{
  const char *e;
  char *buff;

  /* Terminate on a NULL pointer or when we have reached the end of the
     string.  */
  if (*ptr == NULL || **ptr == '\0')
    return NULL;

  /* Find the delimiter.  */
  for (e = *ptr; *e && *e != delim; e++)
    ;

  buff = (char *) malloc ((2 + e - *ptr) * sizeof (char));
  memcpy (buff, *ptr, e - *ptr);
  buff[e - *ptr] = '\0';
  *ptr = e + 1;
  return buff;
}
