#!/usr/bin/perl
# Site specific virtual server generation
# Demo version for RedHat GNU/Linux

# site_make_vs <vsconf>
sub site_make_vs {
    my ($vsconf);

    $vsconf = $_[0];

    # Place in here any additional files and directories
    # and low level configuration stuff.
    # This could probably remain empty as you would normally
    # put all files in skel-repo.

    # Use $vsdir if you want the path to the virtual server
    # directory.
}

# site_config_vs <vsconf> <fqdn>
# Final configuration for a virtual server
# Could include setting quotas for users, adding and configuring
# extra users, fixing the IP addresses and hostnames of various
# files that have been included in the site skel-repo.
sub site_config_vs {
  my ($vs, $ip, $fqdn, $startuid, $numuid, $enduid);
  my ($c, $fh);

  $vsconf = $_[0];
  $fqdn = $_[1];

  $startuid = $vsconf->{"StartUID"};
  $enduid = $vsconf->{"StartUID"} + $vsconf->{"Users"} - 1;

  # Fix the IP address and FQDN for Apache's web server configuration
  # files.
  if (-e "$vsdir/etc/httpd.conf") {
    `cp $vsdir/etc/httpd.conf /tmp/httpd.conf`;
    open (HIN, "/tmp/httpd.conf") or die "cant open: $!";
    open (HOUT, ">$vsdir/etc/httpd.conf");
    while (<HIN>) {
      $_ =~ s/\#BINDADDR\#/$vsconf->{"IP"}/;
      $_ =~ s/\#HOSTNAME\#/$fqdn/;
      print HOUT $_
    }
    close (HOUT);
    close (HIN);
    unlink ("/tmp/httpd.conf");
  }

  if (-e "$vsdir/etc/httpd/conf/httpd.conf") {
    `cp $vsdir/etc/httpd/conf/httpd.conf /tmp/httpd.conf`;
    open (HIN, "/tmp/httpd.conf") or die "cant open: $!";
    open (HOUT, ">$vsdir/etc/httpd/conf/httpd.conf");
    while (<HIN>) {
      $_ =~ s/\#HOSTNAME\#/$fqdn/;
      $_ =~ s/\#BINDADDR\#/$vsconf->{"IP"}/;
      print HOUT $_
    }
    close (HOUT);
    close (HIN);
    unlink ("/tmp/httpd.conf");
  }

  # Fix the IP address for the SSH daemon
  # Config layout for OpenSSH
  if(-e "$vsdir/etc/ssh/sshd_config") {
    `cp $vsdir/etc/ssh/sshd_config /tmp/sshd_config`;
    open(HIN, "/tmp/sshd_config") or die "can't open: $!";
    open(HOUT, ">$vsdir/etc/ssh/sshd_config");
    while(<HIN>) {
      $_ =~ s/\#BINDADDR\#/$vsconf->{"IP"}/;
      print HOUT $_;
    }
    close(HIN);
    close(HOUT);
    unlink("/tmp/sshd_config");
  }

  # Config layout for SSH2 if present
  if(-e "$vsdir/etc/ssh2/sshd2_config") {
    `cp $vsdir/etc/ssh2/sshd2_config /tmp/sshd2_config`;
    open(HIN, "/tmp/sshd2_config") or die "can't open: $!";
    open(HOUT, ">$vsdir/etc/ssh2/sshd2_config");
    while(<HIN>) {
      $_ =~ s/\#BINDADDR\#/$vsconf->{"IP"}/;
      print HOUT $_;
    }
    close(HIN);
    close(HOUT);
    unlink("/tmp/sshd2_config");
  }

  if (!defined($childpid = fork ())) {
    die "cannot fork: $!";
  } elsif ($childpid == 0) {
    # child
    chroot ($vsdir);
    chdir ("/");

    $gid_admin = $startuid;
    $gid_mail = $startuid + 1;
    $gid_web = $startuid + 2;
    $gid_ftp = $startuid + 3;
    
    $uid_admin = $gid_admin;
    $uid_web = $gid_web;
    $uid_ftp = $gid_ftp;

    `chown -R admin.admin /home/httpd/docs`;
    `chown -R admin.admin /home/httpd/icons`;
    chown $uid_admin, $gid_admin, "/home";
    `chown -R admin.admin /etc/httpd`;
    `chown -R admin.admin /etc/logrotate.d`;
    mkdir ("/var/log/httpd", 0775);
    chown $uid_admin, $gid_web, "/var/log/httpd";
    chmod (0775, "/var/run");
    chmod (0775, "/var/log/httpd");

    # If the VS has ssh, autogenerate the host key files
    if(-e "/etc/ssh/sshd_config") {
      # host key file for SSH1
      `ssh-keygen -q -f /etc/ssh/ssh_host_key -N ''`;
      # host key file for SSH2 DSA authentication
      `ssh-keygen -q -d -f /etc/ssh/ssh_host_dsa_key -N ''`;
    }
    exit;
  } else {
    waitpid ($childpid, 0);
  }
}

1;
