#!/usr/bin/perl
# Script for uninstalling FreeVSD following compilation from source.
# (RedHat GNU Linux version)
# Copyright (c) 1999, 2000 Idaya Ltd.
#
# This file is part of the Virtual Server Administrator (FreeVSD)
#
# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

use lib qw(@vsdperllib@);
use VSD;

$vsdconfdir="@vsdconfdir@";
$vsdcertdir = "$vsdconfdir/vsd";
($vsconf, $aliasip) = vsd_map_read ("@vsdconf@", $vs);
$mntpoint = $vsconf->{"Partition"};

# Ensure we are only run once
unless (-f "/etc/services.pre-freevsd") {
    die "Error: FreeVSD already uninstalled\n"; 
}

print ("Restore /etc/services from /etc/services.pre-freevsd? [Y] : ");
if (confirmy()) {
    `/bin/mv /etc/services.pre-freevsd /etc/services`;
}

if ( -e "/etc/inetd.conf")
{
  print ("Restore /etc/inetd.conf from /etc/inetd.conf.pre-freevsd? [Y] : ");
  if (confirmy()) {
      `/bin/mv /etc/inetd.conf.pre-freevsd /etc/inetd.conf`;
  }
  print ("Forcing inetd to read changes...\n");
  `/usr/bin/killall -HUP inetd`;
}

if ( -e "/etc/xinetd.conf")
{
  print ("Restore /etc/xinetd.conf from /etc/xinetd.conf.pre-freevsd? [Y] : ");
  if (confirmy()) {
      `/bin/mv /etc/xinetd.conf.pre-freevsd /etc/xinetd.conf`;
  }
  print ("Forcing xinetd to read changes...\n");
  `/usr/bin/killall -HUP xinetd`;
}

print ("Remove $vsdconfdir/freevsd.conf? [Y] : ");
if (confirmy()) {
    `/bin/rm -f $vsdconfdir/freevsd.conf`;
}

print ("Remove $vsdconfdir/vsd.conf? [Y] : ");
if (confirmy()) {
    `/bin/rm -f $vsdconfdir/vsd.conf`;
}

print ("Enable httpd at startup? [Y] : ");
if (confirmy()) {
    `/sbin/chkconfig httpd on`;
}

if (-d "$mntpoint/ca") {
    print ("Remove certificate authority $mntpoint/ca? [N] : ");
    if (confirmn()) {
	`/bin/rm -rf $mntpoint/ca`;
    }
}

if (-d "$vsdcertdir") {
    print ("Remove authorised certificates in $vsdcertdir? [N] : ");
    if (confirmn()) {
	`/bin/rm -rf $vsdcertdir`;
    }
}

if (-d "$mntpoint/skel") {
    print ("Remove skel $mntpoint/skel? [N] : ");
    if (confirmn()) {
	print ("Remove mount point and all virtual servers beneath $mntpoint? [N] : ");
	if (confirmn()) {
	    `/bin/rm -rf $mntpoint`;
	}
	else {
	    `/bin/rm -rf $mntpoint/skel`;
	}
    }
}

sub confirmy {
    $_ = <>;
    return 0 if (/^n.*/i);
    return 1;
}

sub confirmn {
    $_ = <>;
    return 1 if (/^y.*/i);
    return 0;
}






