#!/usr/bin/perl
# Script for installing FreeVSD following compilation from source.
# (RedHat GNU Linux version)
# Copyright (c) 1999, 2000 Idaya Ltd.
#
# This file is part of the Virtual Server Administrator (FreeVSD)
#
# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

use Fcntl;

# Correct settings substituted by a 'make install' of FreeVSD
$sbindir="@vsdsbindir@";
$vsdconf="@vsdconf@";

# Ensure we are only run once
if (-f "/etc/services.pre-freevsd") {
    die "Error: FreeVSD already installed\n"; 
}

print ("Enter mount point for FreeVSD skel and virtual servers [/home/vsd] : ");
$mntpoint = <>;
$mntpoint = "/home/vsd" if (length $mntpoint == 1);

$resolv="/etc/resolv.conf";
open(RESOLV, "< $resolv") or die("error opening $resolv: $!");
$match = 0;
while (<RESOLV>) {
    if ($_ =~ /^nameserver\s*(\d+).(\d+).(\d+).(\d+)*/i) {
	$ip = "$1.$2.$3.$4";
	if ($match == 0) {
	    $pnsip = $ip;
	    $match = 1;
	}
	elsif ($match == 1) {
	    $snsip = $ip;
	    $match = 2;
	}
    } 
}
close(RESOLV) or die("error closing $resolv: $!");
print ("Enter IP address of primary name server [$pnsip] : ");
$pns = <>;
$pns = $pnsip if ($pns == "");
print ("Enter IP address of secondary name server [$snsip] : ");
$sns = <>;
$sns = $snsip if ($sns == "");

# Modify configuration file
print ("\nCustomising configuration file...\n");
print (" Configured the following lines in $vsdconf:\n");
$old="$vsdconf";
$new="$vsdconf.tmp";
open(OLD, "< $old") or die("error opening $old: $!");
sysopen(NEW, $new, O_WRONLY|O_CREAT|O_EXCL) or die("error opening $new: $!");
while (<OLD>) {
    if ($_ =~ /PrimaryNS/) {
	print NEW "PrimaryNS $pns\n"  or die("error writing to $new: $!");
	print "  PrimaryNS $pns\n";
    }    
    elsif ($_ =~ /SecondaryNS/) {
	print NEW "SecondaryNS $sns\n"  or die("error writing to $new: $!");
	print "  SecondaryNS $sns\n";
    }
    elsif ($_ =~ /Mount/) {
	print NEW "Mount $mntpoint\n"  or die("error writing to $new: $!");
	print "  Mount $mntpoint\n";
    }
    else {
	print NEW $_  or die("error writing to $new: $!");
    }
}
close(OLD) or die("error closing $old: $!");
close(NEW) or die("error closing $new: $!");
rename($old, "$old.orig") or die("error renaming $old to $old.orig: $!");
rename($new, $old) or die("error renaming $new to $old: $!");
`/bin/rm -f $old.orig`;

# Virtualise relevant services
# inetd configuration section
if ( -e "/etc/inetd.conf" ){
  $old="/etc/inetd.conf";
  print ("\nVirtualising the following services (ftp, telnet, pop-3, smtp)...\n");
  print (" hash commented the following lines in /etc/inetd.conf:\n");
  $new="/etc/inetd.tmp-freevsd";
  open(OLD, "< $old") or die("error opening $old: $!");
  sysopen(NEW, $new, O_WRONLY|O_CREAT|O_EXCL) or die("error opening $new: $!");
  while (<OLD>) {
      if ((($_ =~ /^ftp/) or ($_ =~ /^telnet/) or ($_ =~ /^pop-3/) or ( $_ =~ /^smtp/)) and ($_ !~ /^\s*\#/)) {
  	print NEW "#$_"  or die("error writing to $new: $!");
  	print "  $_";
      }
      else {
  	print NEW $_  or die("error writing to $new: $!");
      }
  }
  close(OLD) or die("error closing $old: $!");
close (NEW)
     or die ("error closing $new: $!");
  rename($old, "$old.pre-freevsd") or die("error renaming $old to $old.pre-freevsd: $!");
  rename($new, $old) or die("error renaming $new to $old: $!");
  
  `/bin/grep -q "usr/sbin/proftpd" /etc/inetd.conf || echo "ftp stream tcp nowait root $sbindir/virtuald tcpd  /usr/sbin/proftpd -d -l" >>/etc/inetd.conf`;
  `/bin/grep -q "usr/sbin/in.telnetd" /etc/inetd.conf || echo "telnet stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/in.telnetd" >>/etc/inetd.conf`;
  `/bin/grep -q "usr/sbin/in.qpopper" /etc/inetd.conf || echo "pop-3 stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/in.qpopper" >>/etc/inetd.conf`;
  `/bin/grep -q "usr/sbin/sendmail" /etc/inetd.conf || echo "smtp stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/sendmail -bs" >>/etc/inetd.conf`;
  
  print ("\n");
  print ("Appended the following lines to /etc/inetd.conf:\n");
  print ("  ftp stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/in.ftpd -d -l\n");
  print ("  telnet stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/in.telnetd\n");
  print ("  pop-3 stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/ipop3d\n");
  print ("  smtp stream tcp nowait root $sbindir/virtuald tcpd /usr/sbin/sendmail -bs\n\n");
}# end of inetd configuration

# xinetd configuration
if ( -e "/etc/xinetd.conf"){
  $old="/etc/xinetd.conf";
  $new="/etc/xinetd.tmp-freevsd";
  sysopen(NEW, $new, O_WRONLY|O_CREAT|O_EXCL) or die("error opening $new: $!");
  print ("\nVirtualising the following services in /etc/xinetd.conf...\n");
  open(OLD, "< $old") or die("error opening $old: $!");
  while ($line = <OLD>) {

      # Make sure entires that are NOT to be virtualised are copied to new config file
      if ((($line =~ /^service vsd/) or ($line =~ /^service vsmon/) or ($line =~ /^defaults/)) and ($line !~ /^\s*\#/)){
          print NEW $line or die("error writing to $new: $!");
          while ($line = <OLD>){
              print NEW $line or die("error writing to $new: $!");
              last if $line =~ /}/
          }
      }
      # Virtualise all other services
      elsif (($line =~ /^service \S/) and ($line !~ /^\s*\#/)) {
          my $old_server, $server_args;
          # Set $old_server and $server_args to null string for each new service found
          $old_server = "";
          $server_args = "";
          print NEW $line;
          # Run through service and pick out the server and its agruments
          while ($line = <OLD>){
            if ($line =~ /^\s*server\s*= (\S+)/){
              $old_server = $1;
              print "   $old_server\n";
            }
            elsif ($line =~ /^\s*server_args\s*= (.*)/){
              $server_args = $1;
            }
            # last line in service found so print virtuald as server, and the old server and its arguments as server_args
            elsif ($line =~ /}/){
              print NEW "	server		= $sbindir/virtuald\n" or die("error writing to $new: $!");
              print NEW "	server_args	= $old_server $server_args\n" or die("error writing to $new: $!");
              print NEW $line or die("error writing to $new: $!");
              last;
            }
            else {
              print NEW $line or die("error writing to $new: $!");
            }
          }
      }
      else {
          print NEW $line  or die("error writing to $new: $!");
      }
  }
  close(OLD) or die("error closing $old: $!");
  close(NEW) or die("error closing $new: $!");
  rename($old, "$old.pre-freevsd") or die("error renaming $old to $old.pre-freevsd: $!");
  rename($new, $old) or die("error renaming $new to $old: $!");

  # Having virtualised existing services, check for a defaults section and for various useful utils
  # and add them if they are not there. Apologies for bad piece of scripting, but it saved opening 
  # the file again and searching for the services
  `/bin/grep -q "defaults" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "defaults" >> /etc/xinetd.conf; \
                                                echo "{" >> /etc/xinetd.conf; \
                                                echo "	only_from = 127.0.0.1\\32" >> /etc/xinetd.conf; \
                                                echo "}" >> /etc/xinetd.conf)`;

  `/bin/grep -q "usr/sbin/proftpd" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "service ftp" >> /etc/xinetd.conf; \
                                                        echo "{" >> /etc/xinetd.conf; \
                                                        echo "     socket_type     = stream" >> /etc/xinetd.conf; \
                                                        echo "     protocol        = tcp" >> /etc/xinetd.conf; \
                                                        echo "     wait            = no" >> /etc/xinetd.conf; \
                                                        echo "     user            = root" >> /etc/xinetd.conf; \
                                                        echo "     server          = $sbindir/virtuald" >> /etc/xinetd.conf; \
                                                        echo "     server_args     = /usr/sbin/proftpd -d -l" >> /etc/xinetd.conf; \
                                                        echo "}" >> /etc/xinetd.conf)`;

  `/bin/grep -q "usr/sbin/in.telnetd" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "service telnet" >> /etc/xinetd.conf; \
                                                           echo "{" >> /etc/xinetd.conf; \
                                                           echo "     socket_type     = stream" >> /etc/xinetd.conf; \
                                                           echo "     protocol        = tcp" >> /etc/xinetd.conf; \
                                                           echo "     wait            = no" >> /etc/xinetd.conf; \
                                                           echo "     user            = root" >> /etc/xinetd.conf; \
                                                           echo "     server          = $sbindir/virtuald" >> /etc/xinetd.conf; \
                                                           echo "     server_args     = /usr/sbin/in.telnetd" >> /etc/xinetd.conf; \
                                                           echo "}" >> /etc/xinetd.conf)`;

  `/bin/grep -q "usr/sbin/in.qpopper" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "service pop-3" >> /etc/xinetd.conf; \
                                                           echo "{" >> /etc/xinetd.conf; \
                                                           echo "     socket_type     = stream" >> /etc/xinetd.conf; \
                                                           echo "     protocol        = tcp" >> /etc/xinetd.conf; \
                                                           echo "     wait            = no" >> /etc/xinetd.conf; \
                                                           echo "     user            = root" >> /etc/xinetd.conf; \
                                                           echo "     server          = $sbindir/virtuald" >> /etc/xinetd.conf; \
                                                           echo "     server_args     = /usr/sbin/in.qpopper" >> /etc/xinetd.conf; \
                                                           echo "}" >> /etc/xinetd.conf)`;

  `/bin/grep -q "usr/sbin/sendmail" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "service smtp" >> /etc/xinetd.conf; \
                                                         echo "{" >> /etc/xinetd.conf; \
                                                         echo "     socket_type     = stream" >> /etc/xinetd.conf; \
                                                         echo "     protocol        = tcp" >> /etc/xinetd.conf; \
                                                         echo "     wait            = no" >> /etc/xinetd.conf; \
                                                         echo "     user            = root" >> /etc/xinetd.conf; \
                                                         echo "     server          = $sbindir/virtuald" >> /etc/xinetd.conf; \
                                                         echo "     server_args     = /usr/sbin/sendmail -bs" >> /etc/xinetd.conf; \
                                                         echo "}" >> /etc/xinetd.conf)`;

  print "\n";
  print "Appended the following services to /etc/xinetd.conf:\n";
  print "  service ftp: /usr/sbin/proftpd -d -l\n";
  print "  service telnet: /usr/sbin/in.telnetd\n";
  print "  service pop-3: /usr/sbin/in.qpopper\n";
  print "  service smtp: /usr/sbin/sendmail -bs\n\n";
}


# Register the vsd service
print ("Registering the vsd service...");
`/bin/cp /etc/services /etc/services.pre-freevsd`;
`/bin/grep -q "vsd" /etc/services || echo "vsd 1725/tcp" >>/etc/services`;
print ("\n");
print ("Appended the following lines to /etc/services:\n");
print ("  vsd 1725/tcp\n\n");

# Checking for and creating vsd entry in inetd/xinetd configuration
if ( -e "/etc/inetd.conf")
{
  `/bin/grep -q "$sbindir/vsd" /etc/inetd.conf || echo "vsd stream tcp nowait root $sbindir/vsd vsd" >>/etc/inetd.conf`;
  print ("Appended the following lines to /etc/inetd.conf:\n");
  print ("  vsd stream tcp nowait root $sbindir/vsd vsd\n\n");
}

if (-e "/etc/xinetd.conf")
{
  `/bin/grep -q "$sbindir/vsd" /etc/xinetd.conf || (echo "" >> /etc/xinetd.conf ; echo "service vsd" >> /etc/xinetd.conf; \
                                                    echo "{" >> /etc/xinetd.conf; \
                                                    echo "     socket_type     = stream" >> /etc/xinetd.conf; \
                                                    echo "     protocol        = tcp" >> /etc/xinetd.conf; \
                                                    echo "     wait            = no" >> /etc/xinetd.conf; \
                                                    echo "     user            = root" >> /etc/xinetd.conf; \
                                                    echo "     server          = $sbindir/virtuald" >> /etc/xinetd.conf; \
                                                    echo "     server_args     = /usr/sbin/sendmail -bs" >> /etc/xinetd.conf; \
                                                    echo "}" >> /etc/xinetd.conf)`;

  print ("Appended the following lines to /etc/xinetd.conf:\n");
  print "  service vsd: $sbindir/vsd\n\n";
}
  
print ("Original files saved as /etc/services.pre-freevsd and /etc/inetd.conf.pre-freevsd.\n\n");

# Disable automatic startup of httpd service 
#  and kill any instances which are running
`/sbin/chkconfig httpd off`;
`/usr/bin/killall -q httpd`;
print ("Disabled httpd at startup\n");
print ("Killed all httpd processes\n\n");

# Sending HUP to inetd or xinetd
if (-e "/usr/sbin/inetd")
{
  print ("Forcing inetd to read configuration changes...\n\n");
  `/usr/bin/killall -HUP inetd`;
}

if (-e "/usr/sbin/xinetd")
{
  print ("Forcing xinetd to read configuration changes...\n\n");
  `/usr/sbin/killall -HUP xinetd`;
}

# End of vsd-install.pl main body
