%define freevsd_vrs 1.4.6
%define freevsd_dir freevsd-%freevsd_vrs

Summary: A program to create true Linux virtual servers 
Name: freevsd
Version: %freevsd_vrs
Release: 1
Copyright: GPL
Group: Applications/System
Source: ftp://ftp.freevsd.org/%freevsd_dir/%freevsd_dir.tar.gz
BuildRoot: /var/tmp/%{name}-root
Prefix: %{_prefix}
Vendor: Idaya 
Packager: nigel.lynskey-marett@idaya.co.uk

%description
FreeVSD facilitates true Linux Virtual Servers within a `chroot'
environment, allowing web servers and other applications to be
deployed and administered discretely, without compromise to security.
Each Virtual Server has its own IP address(es), Apache webserver,
and a view of the process table.  FreeVSD expands the Linux system
by creating a pseudo-`super user' (admin) for each Virtual Server.
The admin user has the ability to create extra POP3/FTP and Telnet
users and also administrate vital services such as the webserver.

%package pkgs
Summary: FreeVSD third party packages
Copyright: GPL
Group: Applications/System

%description pkgs
Third party packages patched to create the pseudo-`super user' (admin).

%prep
%setup -q

%build
autoheader
autoconf
%configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var \
	--with-siteconf=./site/linux-redhat --enable-addons=./freevsd-pkgs
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/{usr/bin,usr/sbin,usr/share}
cd $RPM_BUILD_DIR/%freevsd_dir
install host/linux-redhat/doc/vsd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/vsd
make ROOT="${RPM_BUILD_ROOT}" install
cp ${RPM_BUILD_ROOT}/etc/freevsd.conf ${RPM_BUILD_ROOT}/freevsd.conf
sed -e "/third party/d" -e "/add_ons/d" < ${RPM_BUILD_ROOT}/freevsd.conf \
	> ${RPM_BUILD_ROOT}/etc/freevsd.conf
rm -f ${RPM_BUILD_ROOT}/freevsd.conf

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add vsd
grep -q "vsd" /etc/services || echo "vsd 1725/tcp" >>/etc/services
grep -q "sbin/vsd" /etc/inetd.conf || echo "vsd stream tcp nowait root /usr/sbin/vsd vsd" >>/etc/inetd.conf

%post pkgs
if [ -e /etc/freevsd.conf ]; then
	echo "# Path to third party RPMs to install" >>/etc/freevsd.conf
	echo "\$add_ons = '/usr/share/freevsd/pkgs';" >>/etc/freevsd.conf
fi

#%preun
#if [ $1 = 0 ]; then
#  /sbin/chkconfig --del vsd
#fi

#%triggerpostun -- freevsd
#/sbin/chkconfig --add vsd

%files
%defattr(-,root,root)
%config /etc/rc.d/init.d/vsd
%config(noreplace) /etc/freevsd.conf
%config(noreplace) /etc/vsd.conf
%doc INSTALL NEWS README doc/*
%attr(4755, root, root) %{_prefix}/bin/bevs
%attr(0750, root, root) %{_prefix}/sbin/vsboot
%attr(0755, root, root) %{_prefix}/sbin/virtuald
%attr(0750, root, root) %{_prefix}/sbin/vsdadm
%attr(0750, root, root) %{_prefix}/sbin/vsd
%attr(0750, root, root) %{_prefix}/sbin/vsd-genskel.pl
%attr(0750, root, root) %{_prefix}/sbin/vsd-refreshskel.pl 
%attr(0750, root, root) %{_prefix}/sbin/vsd-vsbatch.pl
%attr(0750, root, root) %{_prefix}/sbin/vsd-install.pl
%attr(0750, root, root) %{_prefix}/sbin/vsd-uninstall.pl
%attr(0755, root, root) %{_prefix}/include/libvsd.h
%attr(0755, root, root) %{_prefix}/lib/libvsd.a
%{_prefix}/share/freevsd/VSD.pm
%{_prefix}/share/freevsd/scripts
%{_prefix}/share/freevsd/skel-repo

%files pkgs
%{_prefix}/share/freevsd/pkgs

%changelog 
* Fri Feb 16 11:54:18 2001 Nigel Marett nigel.lynskey-marett@idaya.co.uk
- Tweeked for 1.4.6-1 rpm's added  %{_prefix}/sbin/vsd-refreshskel.pl
- Added Vendor,packager

* Mon Nov 13 2000  Tim Sellar <tim@idaya.net>
- use install/uninstall scripts

* Thu Nov 02 2000  Tim Sellar <tim@idaya.net>
- remove dependencies between rpms

* Thu Jul 06 2000  Nick Burrett <nick@dsvr.net>
- split into two rpms

* Wed May 31 2000  Nick Burrett <nick@dsvr.net>
- initial rpm build
