package VSD;
# Perl module for reading vsd.conf
# Copyright (c) 2000 Idaya Ltd.
# Written by Nick Burrett <nick@dsvr.net>

# This file is part of the Virtual Server Administrator (FreeVSD)

# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Exporter;

@ISA = ('Exporter');
@EXPORT = qw(&vsd_map_read &vsd_map_list);

# Get configuration for a virtual server
sub vsd_map_read {
  my ($mapfile) = $_[0];
  my ($vs) = $_[1];
  my ($ip, $startuid, $users, $quota, $partition);
  my ($status, $primaryns, $secondaryns, %ret);
  my (@aliasip, @device, @mount, @maxvs);

  @device = ();
  @mount = ();
  @maxvs = ();
  open (CONFIG, "$mapfile");
  while (<CONFIG>) {
    chomp; # remove newlines
    s/\#.*//; # remove comments
    s/^\s+//; # no leading white
    s/\s+$//; # no trailing white
    next unless length; # skip blank lines

    if (/^<Global>/) {
      while (<CONFIG>) {
	chomp;
	s/\#.*//; # remove comments
	s/^\s+//; # no leading white
	s/\s+$//; # no trailing white
	next unless length; # skip blank lines

	last if (/<\/Global>/);
	($p1, $p2) = split (/ /, $_);
	$global{"PrimaryNS"} = $p2 if (/PrimaryNS/);
	$global{"SecondaryNS"} = $p2 if (/SecondaryNS/);
	$global{"ErrorLog"} = $p2 if (/ErrorLog/);
	$global{"UIDRange"} = $p2 if (/UIDRange/);
	$global{"UIDAllocChunk"} = $p2 if (/UIDAllocChunk/);
	$global{"BWLimit"} = $p2 if (/BWLimit/);
	$global{"BWBurst"} = $p2 if (/BWBurst/);
      }
    } elsif (/^<Partition /) {
      $part = (split (/ /, $_))[1];
      $part =~ s/[^0-9]+//;
      while (<CONFIG>) {
	chomp;
	s/\#.*//; # remove comments
	s/^\s+//; # no leading white
	s/\s+$//; # no trailing white
	next unless length; # skip blank lines

	last if (/<\/Partition>/);
	($p1, $p2) = split (/ /, $_);
	$device[$part] = $p2 if (/Device/);
	$mount[$part] = $p2 if (/Mount/);
	$maxvs[$part] = $p2 if (/MaxVS/);
      }
    } elsif (/^<VirtualServer $vs>/) {
      @aliasip = ();
      undef ($primaryns);
      undef ($secondaryns);
      while (<CONFIG>) {
	chomp;
	s/\#.*//; # remove comments
	s/^\s+//; # no leading white
	s/\s+$//; # no trailing white
	next unless length; # skip blank lines

	last if (/<\/VirtualServer>/);
	($p1, $p2) = split (/ /, $_);
	$ip = $p2 if (/^IP/);
	$startuid = $p2 if (/StartUID/);
	$users = $p2 if (/Users/);
	$quota = $p2 if (/Quota/);
	$partition = $p2 if (/Partition/);
	$status = $p2 if (/Status/);
	$primaryns = $p2 if (/PrimaryNS/);
	$secondaryns = $p2 if (/SecondaryNS/);
	$bwlimit = $p2 if (/BWLimit/);
	$bwburst = $p2 if (/BWBurst/);
	push (@aliasip, $p2) if (/AliasIP/);
      }
      last;
    }
  }
  close CONFIG;

  $primaryns = $global{"PrimaryNS"} if (! defined $primaryns);
  $secondaryns = $global{"SecondaryNS"} if (! defined $secondaryns);
  $bwlimit = $global{"BWLimit"} if (! defined $bwlimit);
  $bwburst = $global{"BWBurst"} if (! defined $bwburst);
  %ret = ("Name" => $vs,
	  "IP" => $ip,
	  "StartUID" => $startuid,
	  "Users" => $users,
	  "Quota" => $quota,
	  "Partition" => $mount[$partition],
	  "Status" => $status,
	  "PrimaryNS" => $primaryns,
	  "SecondaryNS" => $secondaryns,
	  "BWLimit" => $bwlimit,
	  "BWBurst" => $bwburst);
  return ( \%ret, \@aliasip );
}

# Get a list of all defined virtual servers
sub vsd_map_list {
  my ($mapfile) = $_[0];
  my ($vs, @vslist);

  @vslist = ();
  open (CONFIG, "$mapfile");
  while (<CONFIG>) {
    chomp; # remove newlines
    s/\#.*//; # remove comments
    s/^\s+//; # no leading white
    s/\s+$//; # no trailing white
    next unless length; # skip blank lines

    if (/^<VirtualServer /) {
      $vs = (split (/ /, $_))[1];
      $vs =~ s/>//;
      push (@vslist, $vs);
    }
  }
  close CONFIG;
  return @vslist;
}

1;
