#!/usr/bin/perl
# Script for creating certificate/private key pair for a virtual server 
# (RedHat GNU/Linux version)
# Copyright (c) 2000 Idaya Ltd.
#
# This file is part of the Virtual Server Administrator (FreeVSD)
#
# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

if (@ARGV != 1) {
  print "syntax: vsd-gencert.pl <virtual server>\n";
  exit 1;
}
$vs = $ARGV[0];

$vsdcertdir = "@vsdconfdir@/vsd";
$caroot = "@vsdconfdir@/vsd/ca";
$conf = "@vsdconfdir@/vsd/ca/openssl.cnf";
$vstype = "$caroot/vs-certs";

# Some basic sanity checks
die "$caroot doesn't exist.  Run vsd-genca.pl first\n" if (! -d "$caroot");

# Ensure directory structure exists
mkdir ("$vstype", 0755) if (! -d "$vstype");
mkdir ("$vstype/private", 0755) if (! -d "$vstype/private");
mkdir ("$vstype/cert", 0755) if (! -d "$vstype/cert");

# Create an x509 certificate and private key.  Set an expiry of 365 days
system ("openssl", "req", "-nodes", "-new", "-x509",
	"-out", "$vstype/private/$vs.pem", "-keyout",
	"$vstype/private/$vs.pem", "-days", "365",
	"-config", "$conf");

# Convert x509 certificate into a certificate-request and sign it with
# the private key that we have just created
system ("openssl", "x509", "-x509toreq",
    	"-in", "$vstype/private/$vs.pem",
	"-signkey", "$vstype/private/$vs.pem", "-out", "$vs.tmp.pem");

# Sign the certificate request with the certificate authority.  This
# will produce out public key and store it in the `cert' directory.
system ("openssl", "ca", "-config", "$conf",
	"-policy", "policy_anything", "-days", "365",
	"-out", "$vstype/cert/$vs.pem", "-infiles", "$vs.tmp.pem");

unlink ("$vs.tmp.pem");

# Establish certificates for authorisation
system ("cp", "$vstype/private/$vs.pem", "$vsdcertdir/server/$vs.key");
system ("cp", "$vstype/cert/$vs.pem", "$vsdcertdir/server/$vs.crt");
system ("cp", "$vstype/private/$vs.pem", "$vsdcertdir/client/$vs.key");
system ("cp", "$vstype/cert/$vs.pem", "$vsdcertdir/client/$vs.crt");

exit 0;








