#!/usr/bin/perl
# Script for creating certificate authority (CA) on a hosting server. 
# (RedHat GNU/Linux version)
# Copyright (c) 2000 Idaya Ltd.
#
# This file is part of the Virtual Server Administrator (FreeVSD)
#
# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

$vsdcertdir = "@vsdconfdir@/vsd";
$caroot = "@vsdconfdir@/vsd/ca";
$vstype = "$caroot/vs-certs";

# Create basic CA directory structure
print "-- creating ca, $vsdcertdir\n";
mkdir ("$vsdcertdir", 0755) unless (-d "$vsdcertdir");
if (-d "$caroot") {
  print "-- deleting old ca, $vsdcertdir\n";
  system ("rm", "-rf", "$caroot");
}
mkdir ("$caroot", 0755);

foreach $dir ("private", "certs", "crl", "newcerts") {
  mkdir ("$caroot/$dir", 0755);
}

system ("cp", "@vsddatadir@/freevsd/openssl.cnf", "$caroot/openssl.cnf");

# The serial number gets incremented each time a new certificate is signed
open (OUT, ">$caroot/serial");
print OUT "01\n";
close (OUT);

# index.txt contains the serial number and CN for each certificate signed
open (OUT, ">$caroot/index.txt"); close (OUT);

# Now create a certificate/private key pair for the CA.  The private key
# is called `cakey.pem' and the certificate is `cacert.pem'.  These file
# names and locations are set by the OpenSSL configuration file (openssl.cnf).
system ("/usr/bin/openssl", "req", "-new", "-x509",
	"-keyout", "$caroot/private/cakey.pem", "-out", "$caroot/cacert.pem",
	"-days", "3650", "-config", "$caroot/openssl.cnf");

# Strip passphrase from  private key. This saves us a bit of manual typing
rename ("$caroot/private/cakey.pem", "$caroot/private/cakey.pem.passphrase");
system ("/usr/bin/openssl", "rsa",
	"-in", "$caroot/private/cakey.pem.passphrase",
	"-out", "$caroot/private/cakey.pem");

foreach $dir ("client", "server") {
  mkdir ("$vsdcertdir/$dir", 0755);
}

# Establish CA certificate for authorisation
system ("cp", "$caroot/private/cakey.pem", "$vsdcertdir/server/ca-cert.pem");
exit 0;





