#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];

/* See fork */

int
sj_vfork (struct pt_regs regs)
{
  int sj_vfork_return;

#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
write_lock(&priv_lock);
#endif

#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif
#ifdef DEBUG
       printk("  (StJude) sj_vfork: Entered sj_vfork()\n");
#endif


if (!(current->euid && current->uid && current->suid))
       { 
      struct sj_priv *priv;
      
      priv = get_priv_record(current->pid);
      if (!priv)
	{
#ifdef __SMP__
           write_lock(&argv_memory_lock);
#endif
           suid_hack(current);
#ifdef __SMP__
           write_unlock(&argv_memory_lock);
#endif
        }
      }
#ifdef __SMP__
write_unlock(&priv_lock);
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif

  sj_vfork_return = (*orig_vfork) (regs);

  /* We have to implement vfork support as a hack. The reason is that the vfork call
     will not return UNTILL after an exit() or execeve() by the child process. This
     kinda doesn't work for us since we want to set up some memory stuffs and priv
     stuffs BEFORE it can exec(). Duh.


   */


  return sj_vfork_return;
}
