#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];
                        
/*
 * 
 * On a fork we will need to check if the process has privlage.
 * If yes, then does it have a privlage record?
 *
 *    If it has privlage and no privlage record, then we shall
 *    presume it is a setuid program. At this point we generate
 *    get the index for its restriction, and generate a privlage 
 *    record.
 *
 * If we do have a privlage record, then we need to generate a
 * generate a privlage record for our guy based on the parent's
 * informaiton. 
 *
 */
                       
int
sj_fork (struct pt_regs regs)
{
  int sj_fork_return;
  struct sj_argv_memory  * memory;  

#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
#endif

#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif

#ifdef __SMP__
read_unlock(&tasklist_lock);
#endif

  sj_fork_return = (*orig_fork) (regs);
 
#ifdef __SMP__
read_lock(&tasklist_lock);
#endif

#ifdef __SMP__
read_lock(&argv_memory_lock);
#endif

memory = get_argv_memory(current->pid);
if (memory)
   {
          
         memory = create_argv_memory(sj_fork_return,memory->argv);
           if (!memory)
             printk("(StJude) sj_fork: Something bad happened, I can't remember argv's.\n");
   }
   else
    printk("(StJude) sj_fork: Can't Recall argv for %d.\n",current->pid);

#ifdef __SMP__
read_unlock(&argv_memory_lock);
write_lock(&priv_lock);
#endif

if (!(current->euid && current->uid && current->suid))
       { 
      struct sj_priv *child;
      struct sj_priv *parent;
      
      parent = get_priv_record(current->pid);
      if (!parent)
	{
#ifdef __SMP__
           write_lock(&argv_memory_lock);
#endif
           suid_hack(current);
#ifdef __SMP__
           write_unlock(&argv_memory_lock);
#endif

           parent = get_priv_record(current->pid);
	   if (!parent)
		{
		   printk("(StJude) sj_fork: Brace yourself, we are going to crash!\n");
                }
        }

   if (sj_fork_return > 0) {
   
          if (parent)
               child = create_priv_record(sj_fork_return,parent->restriction->r_index); 
           else
	       child = create_priv_record(sj_fork_return,0);

       }
  }

#ifdef __SMP__
write_unlock(&priv_lock);
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif


  return sj_fork_return;
}
