#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];

/* See fork */
int
sj_clone (struct pt_regs regs)
{
  int sj_clone_return;
  struct sj_argv_memory *memory;

#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
#endif

#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif
#ifdef DEBUG
       printk("  (StJude) sj_cline: Entered sj_clone()\n");
#endif

#ifdef __SMP__
read_unlock(&tasklist_lock);
#endif

  sj_clone_return = (*orig_clone) (regs);

#ifdef __SMP__
read_lock(&tasklist_lock);
write_lock(&argv_memory_lock); 
#endif

memory = get_argv_memory(current->pid);
if (!(memory && create_argv_memory(sj_clone_return,memory->argv)))
           printk("(StJude) sj_Clone: Something bad happened, I can't remember argv's.\n");

#ifdef __SMP__
write_unlock(&argv_memory_lock); 
#endif

if (!(current->euid && current->uid && current->suid))
       {  
      struct sj_priv *child;
      struct sj_priv *parent;

#ifdef __SMP__
write_lock(&priv_lock);
#endif
      parent = get_priv_record(current->pid);
      
      if (!parent) {
#ifdef __SMP__
            write_lock(&argv_memory_lock);
#endif
            suid_hack(current);  
#ifdef __SMP__
            write_unlock(&argv_memory_lock);
#endif

           parent = get_priv_record(current->pid);
	   if (!parent)
		{
		   printk("(StJude) sj_fork: Brace yourself, we are going to crash!\n");
                }
        }

/* The way we will handle forks is simple.. We create a priv thinggie
   but with the 0 as its index. Then we assign the value of the parent's 
   priv record to the child.
 */

   if (sj_clone_return > 0) {
  
           if (parent) 
                  child = create_priv_record(sj_clone_return,parent->restriction->r_index); 
            else
                  child = create_priv_record(sj_clone_return,0); 
    

    }

#ifdef __SMP__
write_unlock(&priv_lock);
#endif

 } 

#ifdef __SMP__
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif


  return sj_clone_return;
}

