#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD in effect on the date  above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


inline int
sj_strlen(char *s1, int max_len)
{
    register int             i;

    for (i = 0; i < max_len && s1[i]; i++);

    return i;
}


inline int
sj_strncmp(char *s1, char *s2, int max_len)
{

    register int             i;

    for (i = 0; i < max_len; i++)
	if (s1[i] != s2[i])
	    return 1;
    return 0;
}

char           *
sj_substr(char *s, int start, int end)
{
    int             i;
    char           *buf;

    buf = kmalloc(sizeof(char) * (end - start + 1), GFP_KERNEL);
    for (i = 0; i < (end - start + 1); i++)
	buf[i] = '\0';
    for (i = start; i <= end; i++)
	buf[i] = s[i];

    return buf;

}

int count(char **argv, int max)
{
    int             i = 0;

    if (argv != NULL) {
	for (;;) {
	    char           *p;
	    int             error;

	    error = get_user(p, argv);
	    if (error)
		return error;
	    if (!p)
		break;
	    argv++;
	    if (++i > max)
		return -E2BIG;
	}
    }
    return i;
}
