#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current GNU Lisence Date as of the Date above.
 *  (If you wonder why this is diffrent from the rest of the files 
 *   read down... )
 *
 * Do not modify this Comment.
 */



#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) 
/*
 * Coppied from linux/fs/array.c 
 */


static unsigned long get_phys_addr(struct task_struct *p, unsigned long ptr)
{
    pgd_t          *page_dir;
    pmd_t          *page_middle;
    pte_t           pte;

    if (!p || !p->mm || ptr >= TASK_SIZE)
	return 0;
    /*
     * Check for NULL pgd .. shouldn't happen! 
     */
    if (!p->mm->pgd) {
	printk("<1>get_phys_addr: pid %d has NULL pgd!\n", p->pid);
	return 0;
    }

    page_dir = pgd_offset(p->mm, ptr);
    if (pgd_none(*page_dir))
	return 0;
    if (pgd_bad(*page_dir)) {
	printk("<1>bad page directory entry %08lx\n", pgd_val(*page_dir));
	pgd_clear(page_dir);
	return 0;
    }
    page_middle = pmd_offset(page_dir, ptr);
    if (pmd_none(*page_middle))
	return 0;
    if (pmd_bad(*page_middle)) {
	printk("<1>bad page middle entry %08lx\n", pmd_val(*page_middle));
	pmd_clear(page_middle);
	return 0;
    }
    pte = *pte_offset(page_middle, ptr);
    if (!pte_present(pte))
	return 0;
    return pte_page(pte) + (ptr & ~PAGE_MASK);
}

/*
 * Compiler will compain that we don't call this function. We will.. We just
 * don't.. yet. 
 */

static int
get_array(struct task_struct *p, unsigned long start, unsigned long end,
	  char *buffer)
{
    unsigned long   addr;
    int             size = 0,
                    result = 0;
    char            c;

    if (start >= end)
	return result;
    for (;;) {
	addr = get_phys_addr(p, start);
	if (!addr)
	    return result;
	do {
	    c = *(char *) addr;
	    if (!c)
		result = size;
	    if (size < PAGE_SIZE)
		buffer[size++] = c;
	    else
		return result;
	    addr++;
	    start++;
	    if (!c && start >= end)
		return result;
	} while (addr & ~PAGE_MASK);
    }
    return result;
}

#endif
