#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern SJ_RULEBASE sj_rulebase[];


/*
 * If we set the uid of the process to both non-root
 * ids then we can not transition back into root.
 * At this point we can then remove the privlage
 * entry from the stuff. 
 */

int
sj_setreuid (uid_t ruid, uid_t euid)
{
  int sj_setreuid_return;
  short privlaged = 0;

#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
#endif

#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif

#ifdef DEBUG
printk("(StJude) sj_setreuid: Entered setreuid()\n");
#endif
   
  if ( ! ( current->uid && current->euid && current->suid ) )
    { 
       struct sj_priv *priv;  

       privlaged = 1;

#ifdef __SMP__
       write_lock(&priv_lock);
#endif

        priv = get_priv_record(current->pid);
  
        if(!priv) {
#ifdef __SMP__
           write_lock(&argv_memory_lock);
#endif
           suid_hack(current);  
#ifdef __SMP__
           write_unlock(&argv_memory_lock);
#endif
           }

#ifdef __SMP__
        write_unlock(&priv_lock);
#endif
    }
#ifdef __SMP__
read_unlock(&tasklist_lock);
#endif

  sj_setreuid_return = (*orig_setreuid) (ruid,euid);

#ifdef __SMP__
read_lock(&tasklist_lock);
#endif


  /* If it was privlaged, but is not any more, then we should drip its record */

  if (privlaged && ( current->uid && current->euid && current->suid ) )
    {

#ifdef __SMP__
        write_lock(&priv_lock);
#endif
         destroy_priv_record(current->pid);
#ifdef __SMP__
        write_unlock(&priv_lock);
#endif


    }

#ifdef __SMP__
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif

  return sj_setreuid_return;
}

